/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.crafting;

import com.flansmod.common.crafting.MaterialMatcher;
import com.flansmod.common.types.Definitions;
import com.flansmod.common.types.crafting.EMaterialType;
import com.flansmod.common.types.crafting.MaterialDefinition;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;

public class MaterialDefinitions
extends Definitions<MaterialDefinition> {
    private final HashMap<Integer, MaterialMatcher> MatcherCache = new HashMap();

    public MaterialDefinitions() {
        super("materials", MaterialDefinition.class, MaterialDefinition.INVALID, MaterialDefinition::new);
    }

    @Nonnull
    public MaterialMatcher GetMatcherForThisTier(EMaterialType materialType, int tier, boolean allowHigherTiers) {
        int hash = materialType.ordinal() << 16 | tier << 8 | (allowHigherTiers ? 1 : 0);
        if (this.MatcherCache.containsKey(hash)) {
            return this.MatcherCache.get(hash);
        }
        List<MaterialDefinition> materials = this.Find(matDef -> {
            if (allowHigherTiers) {
                return matDef.materialType == materialType && matDef.craftingTier >= tier;
            }
            return matDef.materialType == materialType && matDef.craftingTier == tier;
        });
        MaterialMatcher matcher = new MaterialMatcher(materials);
        this.MatcherCache.put(hash, matcher);
        return matcher;
    }
}

