/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.elements;

import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.crafting.EMaterialIconType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class MaterialSourceDefinition {
    @JsonField
    public String[] matchItems = new String[0];
    @JsonField
    public String[] matchTags = new String[0];
    @JsonField(Docs="For ref, nugget = 1, ingot = 9, block = 81")
    public int count = 1;
    @JsonField
    public EMaterialIconType icon = EMaterialIconType.ingot;
    private List<ItemStack> Matches = null;

    @Nonnull
    public List<ItemStack> GetMatches() {
        if (this.Matches == null) {
            this.Matches = new ArrayList<ItemStack>();
            ArrayList<ResourceLocation> matchItemLocs = new ArrayList<ResourceLocation>(this.matchItems.length);
            ArrayList<TagKey> matchTagKeys = new ArrayList<TagKey>(this.matchTags.length);
            for (String name : this.matchItems) {
                matchItemLocs.add(new ResourceLocation(name));
            }
            for (String tag : this.matchTags) {
                matchTagKeys.add(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(tag)));
            }
            for (Map.Entry kvp : ForgeRegistries.ITEMS.getEntries()) {
                boolean isMatch = false;
                if (matchItemLocs.contains(((ResourceKey)kvp.getKey()).m_135782_())) {
                    isMatch = true;
                }
                for (TagKey tagKey : matchTagKeys) {
                    if (!((Item)kvp.getValue()).m_204114_().m_203656_(tagKey)) continue;
                    isMatch = true;
                }
                if (!isMatch) continue;
                this.Matches.add(new ItemStack((ItemLike)kvp.getValue()));
            }
        }
        return this.Matches;
    }

    public int AnalyzeStack(ItemStack stack) {
        for (ItemStack checkMatch : this.GetMatches()) {
            if (!ItemStack.m_41656_((ItemStack)stack, (ItemStack)checkMatch)) continue;
            return this.count * stack.m_41613_();
        }
        return 0;
    }
}

