/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.elements;

import com.flansmod.common.item.FlanItem;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.abilities.elements.EAccumulationSource;
import com.flansmod.common.types.abilities.elements.StatAccumulatorDefinition;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.util.formulae.EAccumulationOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ModifierDefinition {
    @JsonField
    public String stat = "";
    @JsonField
    public String id = "";
    @JsonField
    public String[] matchGroupPaths = new String[0];
    @JsonField
    public StatAccumulatorDefinition[] accumulators = new StatAccumulatorDefinition[0];
    @JsonField
    public String setValue = "";

    public boolean AppliesTo(@Nonnull String groupPath) {
        if (this.matchGroupPaths.length == 0) {
            return true;
        }
        for (String filter : this.matchGroupPaths) {
            if (!groupPath.contains(filter)) continue;
            return true;
        }
        return false;
    }

    public boolean AppliesTo(@Nonnull String check, @Nonnull String groupPath) {
        return this.stat.equals(check) && this.AppliesTo(groupPath);
    }

    public String GetStatWithId() {
        if (this.id.isEmpty()) {
            return this.stat;
        }
        return this.stat + this.id;
    }

    @Nonnull
    public List<Component> GetModifierStrings() {
        ArrayList<Component> componentList = new ArrayList<Component>();
        MutableComponent statName = Component.m_237115_((String)("modifier.stat_name." + this.stat));
        MutableComponent groupPathComponent = switch (this.matchGroupPaths.length) {
            case 0 -> Component.m_237119_();
            case 1 -> Component.m_237110_((String)"comma_list.brackets", (Object[])new Object[]{Component.m_237115_((String)("action.group_path." + this.matchGroupPaths[0]))});
            default -> Component.m_237110_((String)"comma_list.brackets", (Object[])new Object[]{FlanItem.ListOf("action.group_path.", this.matchGroupPaths)});
        };
        for (StatAccumulatorDefinition accumulator : this.accumulators) {
            MutableComponent valueComponent = switch (accumulator.operation) {
                default -> throw new IncompatibleClassChangeError();
                case EAccumulationOperation.BaseAdd -> Component.m_237113_((String)("+ " + this.PrintIntOrFloat(accumulator.value)));
                case EAccumulationOperation.StackablePercentage -> Component.m_237113_((String)("+ " + this.PrintIntOrFloat(accumulator.value) + "%"));
                case EAccumulationOperation.IndependentPercentage -> Component.m_237113_((String)("* " + this.PrintIntOrFloat(accumulator.value) + "%"));
                case EAccumulationOperation.FinalAdd -> Component.m_237113_((String)("+(After %)" + this.PrintIntOrFloat(accumulator.value)));
            };
            block18: for (EAccumulationSource source : accumulator.multiplyPer) {
                switch (source) {
                    case PerStacks: {
                        valueComponent = Component.m_237110_((String)"modifier.scalar.stacks", (Object[])new Object[]{statName, valueComponent});
                        continue block18;
                    }
                    case PerLevel: {
                        valueComponent = Component.m_237110_((String)"modifier.scalar.level", (Object[])new Object[]{statName, valueComponent});
                        continue block18;
                    }
                    case PerAttachment: {
                        valueComponent = Component.m_237110_((String)"modifier.scalar.attachment", (Object[])new Object[]{statName, valueComponent});
                        continue block18;
                    }
                    case PerMagFullness: {
                        valueComponent = Component.m_237110_((String)"modifier.scalar.mag_full", (Object[])new Object[]{statName, valueComponent});
                        continue block18;
                    }
                    case PerMagEmptiness: {
                        valueComponent = Component.m_237110_((String)"modifier.scalar.mag_empty", (Object[])new Object[]{statName, valueComponent});
                    }
                }
            }
            componentList.add((Component)Component.m_237110_((String)"%s%s %s", (Object[])new Object[]{statName, groupPathComponent, valueComponent}));
        }
        return componentList;
    }

    private String PrintIntOrFloat(float value) {
        if (Maths.approx(value, Maths.round(value))) {
            return Integer.toString(Maths.round(value));
        }
        return Float.toString(value);
    }
}

