/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.guns.elements;

import com.flansmod.common.FlansMod;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.magazines.MagazineDefinition;
import java.util.ArrayList;
import java.util.List;

public class MagazineSlotSettingsDefinition {
    public static final MagazineSlotSettingsDefinition INVALID = new MagazineSlotSettingsDefinition();
    private List<MagazineDefinition> MatchingMagazineReferences = null;
    @JsonField
    public String key = "primary";
    @JsonField
    public String[] matchByNames = new String[0];
    @JsonField
    public String[] matchByTags = new String[0];
    @JsonField(Docs="How many upgrades are needed to perform a swap (not including the ones associated to the mags themselves)")
    public int baseCostToSwap = 0;

    public List<MagazineDefinition> GetMatchingMagazines() {
        if (this.MatchingMagazineReferences == null) {
            this.MatchingMagazineReferences = new ArrayList<MagazineDefinition>(this.matchByNames.length);
            FlansMod.MAGAZINES.RunOnMatches(magazine -> {
                for (String matchBulletName : this.matchByNames) {
                    if (!magazine.Location.m_135815_().equals(matchBulletName)) continue;
                    return true;
                }
                if (this.matchByTags.length > 0) {
                    for (String tag : this.matchByTags) {
                        if (magazine.HasTag(tag)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }, magazine -> {
                if (!this.MatchingMagazineReferences.contains(magazine)) {
                    this.MatchingMagazineReferences.add((MagazineDefinition)magazine);
                }
            });
            this.MatchingMagazineReferences.sort((a, b) -> {
                int costComp = Integer.compare(a.upgradeCost, b.upgradeCost);
                if (costComp == 0) {
                    return Integer.compare(a.numRounds, b.numRounds);
                }
                return costComp;
            });
        }
        return this.MatchingMagazineReferences;
    }
}

