/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.npc;

import com.flansmod.common.FlansModConfig;
import com.flansmod.common.types.JsonDefinition;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.elements.EDamageSourceType;
import com.flansmod.common.types.elements.ItemStackDefinition;
import com.flansmod.common.types.npc.elements.ENpcActionType;
import com.flansmod.common.types.npc.elements.MerchantOfferDefinition;
import com.flansmod.common.types.npc.elements.VoiceLineDefinition;
import com.flansmod.physics.common.util.Maths;
import net.minecraft.resources.ResourceLocation;

public class NpcDefinition
extends JsonDefinition {
    public static final NpcDefinition INVALID = new NpcDefinition(new ResourceLocation("flansmod", "npcs/null"));
    public static final String TYPE = "npc";
    public static final String FOLDER = "npcs";
    @JsonField
    public VoiceLineDefinition[] voiceLines = new VoiceLineDefinition[0];
    @JsonField
    public ItemStackDefinition hat = new ItemStackDefinition();
    @JsonField
    public ItemStackDefinition chest = new ItemStackDefinition();
    @JsonField
    public ItemStackDefinition legs = new ItemStackDefinition();
    @JsonField
    public ItemStackDefinition shoes = new ItemStackDefinition();
    @JsonField
    public ItemStackDefinition mainHand = new ItemStackDefinition();
    @JsonField
    public ItemStackDefinition offHand = new ItemStackDefinition();
    @JsonField
    public ENpcActionType[] validActions = new ENpcActionType[0];
    @JsonField
    public boolean isRightHanded = true;
    @JsonField
    public float cooldownSecondsFriendly = 120.0f;
    @JsonField
    public float cooldownSecondsHostile = 300.0f;
    @JsonField
    public EDamageSourceType[] invulnerabilities = new EDamageSourceType[0];
    @JsonField(Docs="If set to 0, this NPC will not be considered a merchant")
    public int maxMerchantLevel = 0;
    @JsonField
    public int[] xpPerMerchantLevel = new int[0];
    @JsonField
    public int minOffersToGive = 1;
    @JsonField
    public int maxOffersToGive = 5;
    @JsonField
    public MerchantOfferDefinition[] offers = new MerchantOfferDefinition[0];

    @Override
    public String GetTypeName() {
        return TYPE;
    }

    public NpcDefinition(ResourceLocation resLoc) {
        super(resLoc);
    }

    public boolean IsInvulnerableTo(EDamageSourceType sourceType) {
        for (EDamageSourceType invuln : this.invulnerabilities) {
            if (sourceType != invuln) continue;
            return true;
        }
        return false;
    }

    public int CooldownTicks(boolean friendly) {
        double extraCooldown = (Double)FlansModConfig.SummonNpcExtraCooldown.get();
        return Maths.ceil((extraCooldown + (double)(friendly ? this.cooldownSecondsFriendly : this.cooldownSecondsHostile)) * 20.0);
    }

    public boolean Can(ENpcActionType actionType) {
        for (ENpcActionType validActionType : this.validActions) {
            if (validActionType != actionType) continue;
            return true;
        }
        return false;
    }
}

