/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.parts;

import com.flansmod.common.FlansMod;
import com.flansmod.common.item.PartItem;
import com.flansmod.common.types.JsonDefinition;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.abilities.elements.CraftingTraitProviderDefinition;
import com.flansmod.common.types.crafting.EMaterialType;
import com.flansmod.common.types.crafting.MaterialDefinition;
import com.flansmod.common.types.elements.ItemDefinition;
import com.flansmod.common.types.elements.ModifierDefinition;
import com.flansmod.common.types.parts.elements.EngineDefinition;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PartDefinition
extends JsonDefinition {
    @Nonnull
    public static final PartDefinition INVALID = new PartDefinition(new ResourceLocation("flansmod", "parts/null"));
    public static final String TYPE = "part";
    public static final String FOLDER = "parts";
    @JsonField
    public boolean canPlaceInMachiningTable = false;
    @JsonField
    public boolean canPlaceInModificationTable = false;
    @JsonField
    public String[] compatiblityTags = new String[]{"mecha", "groundVehicle", "plane"};
    @JsonField
    public ItemDefinition itemSettings = new ItemDefinition();
    @JsonField
    public ModifierDefinition[] modifiers = new ModifierDefinition[0];
    @JsonField
    public CraftingTraitProviderDefinition[] traits = new CraftingTraitProviderDefinition[0];
    @JsonField
    public EngineDefinition engine = new EngineDefinition();
    @JsonField(AssetPathHint="materials/")
    public ResourceLocation material = InvalidLocation;
    @Nullable
    private MaterialDefinition CachedMaterial = null;

    @Override
    public String GetTypeName() {
        return TYPE;
    }

    public PartDefinition(ResourceLocation resLoc) {
        super(resLoc);
    }

    @Nonnull
    public MaterialDefinition GetMaterial() {
        if (this.CachedMaterial == null) {
            this.CachedMaterial = (MaterialDefinition)FlansMod.MATERIALS.Get(this.material);
        }
        return this.CachedMaterial;
    }

    @Nonnull
    public static MaterialDefinition GetMaterialOfPart(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof PartItem) {
            PartItem partItem = (PartItem)item;
            return partItem.Def().GetMaterial();
        }
        return MaterialDefinition.INVALID;
    }

    public static int GetPartTier(ItemStack stack) {
        return PartDefinition.GetMaterialOfPart((ItemStack)stack).craftingTier;
    }

    @Nonnull
    public static EMaterialType GetPartMaterial(ItemStack stack) {
        return PartDefinition.GetMaterialOfPart((ItemStack)stack).materialType;
    }
}

