/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.parts.elements;

import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.parts.elements.EFuelType;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.MinecraftHelpers;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;

public class EngineDefinition {
    @JsonField
    public float maxAcceleration = 1.0f;
    @JsonField
    public float maxDeceleration = 1.0f;
    @JsonField
    public float maxSpeed = 1.0f;
    @JsonField
    public EFuelType fuelType = EFuelType.Creative;
    @JsonField
    public float fuelConsumptionIdle = 0.0f;
    @JsonField
    public float fuelConsumptionFull = 1.0f;
    @JsonField
    public int solidFuelSlots = 0;
    @JsonField(Docs="In millibuckets")
    public int liquidFuelCapacity = 1000;
    @JsonField
    public int batterySlots = 0;
    @JsonField
    public int FECapacity = 0;

    public int GetCoalPerHourIdle() {
        return Maths.ceil(this.fuelConsumptionIdle * 72000.0f / 800.0f);
    }

    public int GetCoalPerHourFull() {
        return Maths.ceil(this.fuelConsumptionFull * 72000.0f / 800.0f);
    }

    public int GetMilliBucketsPerTickIdle() {
        return Maths.ceil(this.fuelConsumptionIdle);
    }

    public int GetMilliBucketsPerTickFull() {
        return Maths.ceil(this.fuelConsumptionFull);
    }

    public int GetForgeEnergyPerTickIdle() {
        return Maths.ceil(this.fuelConsumptionIdle);
    }

    public int GetForgeEnergyPerTickFull() {
        return Maths.ceil(this.fuelConsumptionFull);
    }

    @Nonnull
    public Component GetFuelConsumptionTooltip() {
        switch (this.fuelType) {
            case Smeltable: 
            case Smokable: 
            case Blastable: {
                int cphIdle = this.GetCoalPerHourIdle();
                int cphFull = this.GetCoalPerHourFull();
                if (cphIdle == cphFull) {
                    return Component.m_237110_((String)"tooltip.format.engine_solid_fuel_consumption", (Object[])new Object[]{cphIdle});
                }
                return Component.m_237110_((String)"tooltip.format.engine_solid_fuel_consumption.range", (Object[])new Object[]{cphIdle, cphFull});
            }
            case Liquid: {
                int mbptIdle = this.GetMilliBucketsPerTickIdle();
                int mbptFull = this.GetMilliBucketsPerTickFull();
                if (mbptIdle == mbptFull) {
                    return Component.m_237110_((String)"tooltip.format.engine_liquid_fuel_consumption", (Object[])new Object[]{mbptIdle});
                }
                return Component.m_237110_((String)"tooltip.format.engine_liquid_fuel_consumption.range", (Object[])new Object[]{mbptIdle, mbptFull});
            }
            case FE: {
                int feptIdle = this.GetForgeEnergyPerTickIdle();
                int feptFull = this.GetForgeEnergyPerTickFull();
                if (feptIdle == feptFull) {
                    return Component.m_237110_((String)"tooltip.format.engine_electric_fuel_consumption", (Object[])new Object[]{feptIdle});
                }
                return Component.m_237110_((String)"tooltip.format.engine_electric_fuel_consumption.range", (Object[])new Object[]{feptIdle, feptFull});
            }
            case Creative: {
                return Component.m_237115_((String)"tooltip.format.engine_creative_consumption");
            }
        }
        return Component.m_237119_();
    }

    @Nonnull
    public Component GetFuelStorageTooltip() {
        switch (this.fuelType) {
            case Smeltable: 
            case Smokable: 
            case Blastable: {
                return Component.m_237110_((String)"tooltip.format.engine_solid_fuel_storage", (Object[])new Object[]{this.solidFuelSlots});
            }
            case Liquid: {
                return Component.m_237110_((String)"tooltip.format.engine_liquid_fuel_storage", (Object[])new Object[]{this.liquidFuelCapacity, this.solidFuelSlots});
            }
            case FE: {
                return Component.m_237110_((String)"tooltip.format.engine_electric_fuel_storage", (Object[])new Object[]{MinecraftHelpers.getFEString(this.FECapacity), this.batterySlots});
            }
            case Creative: {
                return Component.m_237115_((String)"tooltip.format.engine_creative_storage");
            }
        }
        return Component.m_237119_();
    }
}

