/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.collision.threading;

import com.flansmod.physics.client.DebugRenderer;
import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.collision.ColliderHandle;
import com.flansmod.physics.common.collision.StaticCollisionEvent;
import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.collision.obb.FullSeparationResult;
import com.flansmod.physics.common.collision.obb.ICollisionAccessDynamicObject;
import com.flansmod.physics.common.collision.obb.SeparationResult;
import com.flansmod.physics.common.collision.threading.CollisionTasks;
import com.flansmod.physics.common.collision.threading.ICollisionTask;
import com.flansmod.physics.common.util.ProjectedRange;
import com.flansmod.physics.common.util.shapes.IPlane;
import com.flansmod.physics.common.util.shapes.IPolygon;
import com.flansmod.physics.common.util.shapes.ISeparationAxis;
import com.flansmod.physics.common.util.shapes.Plane;
import com.flansmod.physics.common.util.shapes.Polygon;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector4f;

public class CollisionTaskSeparateDynamicFromStatic
implements ICollisionTask<Input, Output> {
    @Nonnull
    public final ColliderHandle Handle;
    @Nullable
    private Input Input;
    @Nullable
    private List<ISeparationAxis> NewSeparators = null;
    @Nullable
    private Output Output;
    private boolean Cancelled = false;

    @Nonnull
    public static CollisionTaskSeparateDynamicFromStatic of(@Nonnull ColliderHandle handleA, @Nonnull ICollisionAccessDynamicObject objectA, @Nonnull ImmutableList<VoxelShape> staticShapes, @Nonnull ImmutableList<ISeparationAxis> existingSeparators) {
        CollisionTaskSeparateDynamicFromStatic task = new CollisionTaskSeparateDynamicFromStatic(handleA);
        task.prepare(new Input(objectA, staticShapes, existingSeparators));
        return task;
    }

    public CollisionTaskSeparateDynamicFromStatic(@Nonnull ColliderHandle handle) {
        this.Handle = handle;
    }

    @Override
    public void prepare(@Nonnull Input input) {
        this.Input = input;
    }

    @Override
    public boolean canRun() {
        return this.Input != null && this.Input.StaticShapes.size() > 0;
    }

    @Override
    public void run() {
        if (this.Input != null) {
            if (this.Input.StaticShapes.size() == 0) {
                this.Output = new Output((ImmutableList<StaticCollisionEvent>)ImmutableList.of(), (ImmutableList<ISeparationAxis>)ImmutableList.of());
                return;
            }
            this.SeparateStaticAABBs();
        }
    }

    private void SeparateStaticAABBs() {
        FullSeparationResult[] results = new FullSeparationResult[this.Input.StaticShapes.size()];
        TransformedBB boundsA = this.Input.ObjectA.getPendingBB();
        ArrayList<ISeparationAxis> newSeparatorList = new ArrayList<ISeparationAxis>();
        ImmutableList.Builder collisions = ImmutableList.builder();
        int totalSeparated = 0;
        for (ISeparationAxis separator : this.Input.ExistingSeparators) {
            ProjectedRange projectionA;
            Plane testPlane = Plane.of(separator, (projectionA = separator.projectOBBMinMax(boundsA)).max());
            int numSeparated = this.ApplySeparation(testPlane, results);
            if (numSeparated <= 0) continue;
            newSeparatorList.add(separator);
            totalSeparated += numSeparated;
        }
        while (totalSeparated < this.Input.StaticShapes.size()) {
            SeparationResult successfulResult;
            FullSeparationResult separationResult;
            int indexToProcess = -1;
            for (int i = 0; i < results.length; ++i) {
                if (results[i] != null) continue;
                indexToProcess = i;
            }
            if (indexToProcess == -1) {
                FlansPhysicsMod.LOGGER.error("Couldn't complete static separation algorithm???");
                break;
            }
            VoxelShape shape = (VoxelShape)this.Input.StaticShapes.get(indexToProcess);
            AABB voxelBB = shape.m_83215_();
            results[indexToProcess] = separationResult = CollisionTasks.separateGetAllOptions(boundsA, voxelBB);
            ++totalSeparated;
            if (!separationResult.success() || (successfulResult = separationResult.getSuccessfulResult()) == null) continue;
            totalSeparated += this.ApplySeparation(successfulResult.separator(), results);
            newSeparatorList.add(successfulResult.separator());
        }
        Vec3 strongestNormalDir = Vec3.f_82478_;
        for (FullSeparationResult fullResult : results) {
            if (fullResult.success()) continue;
            for (SeparationResult option : fullResult.options()) {
                strongestNormalDir = strongestNormalDir.m_82549_(option.separator().getNormal());
            }
        }
        strongestNormalDir = strongestNormalDir.m_82541_();
        DebugRenderer.renderArrow(this.Input.ObjectA.getCurrentLocation(), 3, new Vector4f(1.0f, 1.0f, 0.5f, 1.0f), strongestNormalDir);
        for (int i = 0; i < results.length; ++i) {
            FullSeparationResult fullResult = results[i];
            if (fullResult.success()) continue;
            SeparationResult bestOption = null;
            double bestDotProduct = -1.7976931348623157E308;
            for (SeparationResult option : fullResult.options()) {
                double dot = option.separator().getNormal().m_82526_(strongestNormalDir) * -1.0 / option.depth();
                if (!(dot > bestDotProduct)) continue;
                bestDotProduct = dot;
                bestOption = option;
            }
            if (bestOption == null) continue;
            VoxelShape shape = (VoxelShape)this.Input.StaticShapes.get(i);
            AABB voxelBB = shape.m_83215_();
            Direction referenceSide = bestOption.separator().selectFaceAABBMax(voxelBB);
            Direction incidentSide = bestOption.separator().selectFaceOBBMin(boundsA);
            IPolygon referencePoly = Polygon.of(voxelBB, referenceSide);
            IPolygon incidentPoly = boundsA.GetFace(incidentSide);
            IPolygon collisionPoly = bestOption.separator().collisionClip(incidentPoly, referencePoly);
            collisions.add((Object)new StaticCollisionEvent(collisionPoly, bestOption.separator(), bestOption.depth()));
        }
        this.NewSeparators = newSeparatorList;
        this.Output = new Output((ImmutableList<StaticCollisionEvent>)collisions.build(), (ImmutableList<ISeparationAxis>)ImmutableList.copyOf(this.NewSeparators));
    }

    private int ApplySeparation(@Nonnull IPlane separator, @Nonnull FullSeparationResult[] results) {
        int numSeparated = 0;
        for (int i = 0; i < this.Input.StaticShapes.size(); ++i) {
            VoxelShape shape;
            double heightAbove;
            if (results[i] != null || !((heightAbove = separator.getAABBHeightAbove((shape = (VoxelShape)this.Input.StaticShapes.get(i)).m_83215_())) >= 0.0)) continue;
            results[i] = FullSeparationResult.of(SeparationResult.successful(separator));
            ++numSeparated;
        }
        return numSeparated;
    }

    @Nonnull
    private Pair<Integer, SeparationResult> FindClosestSeparation(TransformedBB boundsA) {
        int shortestIntersectionVoxelIndex = -1;
        SeparationResult shortestIntersection = null;
        double shortestIntersectionDist = Double.MAX_VALUE;
        for (int i = 0; i < this.Input.StaticShapes.size(); ++i) {
            double sepDistance;
            Pair<Double, IPlane> sepResult;
            VoxelShape shape = (VoxelShape)this.Input.StaticShapes.get(i);
            AABB aabb = shape.m_83215_();
            boolean isSeparated = false;
            for (ISeparationAxis separator : this.Input.ExistingSeparators) {
                sepResult = separator.getSeparationPlaneAtoB(boundsA, aabb);
                sepDistance = (Double)sepResult.getFirst();
                if (sepDistance < shortestIntersectionDist) {
                    shortestIntersection = SeparationResult.successful((IPlane)sepResult.getSecond());
                    shortestIntersectionDist = sepDistance;
                    shortestIntersectionVoxelIndex = i;
                }
                if (!(sepDistance >= 0.0)) continue;
                isSeparated = true;
                break;
            }
            if (this.NewSeparators != null) {
                for (ISeparationAxis separator : this.NewSeparators) {
                    sepResult = separator.getSeparationPlaneAtoB(boundsA, aabb);
                    sepDistance = (Double)sepResult.getFirst();
                    if (sepDistance < shortestIntersectionDist) {
                        shortestIntersection = SeparationResult.successful((IPlane)sepResult.getSecond());
                        shortestIntersectionDist = sepDistance;
                        shortestIntersectionVoxelIndex = i;
                    }
                    if (!(sepDistance >= 0.0)) continue;
                    isSeparated = true;
                    break;
                }
            }
            if (isSeparated) continue;
            SeparationResult result = CollisionTasks.separate(boundsA, aabb);
            if (result.depth() < shortestIntersectionDist) {
                shortestIntersection = result;
                shortestIntersectionDist = result.depth();
                shortestIntersectionVoxelIndex = i;
            }
            if (this.NewSeparators == null) {
                this.NewSeparators = new ArrayList<ISeparationAxis>();
            }
            this.NewSeparators.add(result.separator());
        }
        return Pair.of((Object)shortestIntersectionVoxelIndex, shortestIntersection);
    }

    @Override
    public boolean canCancel() {
        return true;
    }

    @Override
    public void cancel() {
        this.Cancelled = true;
    }

    @Override
    public boolean isComplete() {
        return this.Cancelled || this.Output != null;
    }

    @Override
    @Nullable
    public Output getResult() {
        return this.Output;
    }

    @Nullable
    public Input Debug_GetInput() {
        return this.Input;
    }

    public record Input(@Nonnull ICollisionAccessDynamicObject ObjectA, @Nonnull ImmutableList<VoxelShape> StaticShapes, @Nonnull ImmutableList<ISeparationAxis> ExistingSeparators) {
    }

    public record Output(@Nonnull ImmutableList<StaticCollisionEvent> EventsA, @Nullable ImmutableList<ISeparationAxis> NewSeparatorList) {
    }
}

