/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.collision.threading;

import com.flansmod.physics.common.collision.ColliderHandle;
import com.flansmod.physics.common.collision.DynamicCollisionEvent;
import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.collision.obb.ICollisionAccessDynamicObject;
import com.flansmod.physics.common.collision.obb.SeparationResult;
import com.flansmod.physics.common.collision.threading.CollisionTasks;
import com.flansmod.physics.common.collision.threading.ICollisionTask;
import com.flansmod.physics.common.util.shapes.ISeparationAxis;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.phys.Vec3;

public class CollisionTaskSeparateDynamicPair
implements ICollisionTask<Input, Output> {
    @Nonnull
    public final ColliderHandle HandleA;
    @Nonnull
    public final ColliderHandle HandleB;
    @Nullable
    private Input Input;
    @Nullable
    private Output Output;
    private boolean Cancelled = false;

    @Nonnull
    public static CollisionTaskSeparateDynamicPair of(@Nonnull ColliderHandle handleA, @Nonnull ICollisionAccessDynamicObject objectA, @Nonnull ColliderHandle handleB, @Nonnull ICollisionAccessDynamicObject objectB, @Nonnull ImmutableList<ISeparationAxis> existingSeparators) {
        CollisionTaskSeparateDynamicPair task = new CollisionTaskSeparateDynamicPair(handleA, handleB);
        task.prepare(new Input(objectA, objectB, existingSeparators));
        return task;
    }

    public CollisionTaskSeparateDynamicPair(@Nonnull ColliderHandle handleA, @Nonnull ColliderHandle handleB) {
        this.HandleA = handleA;
        this.HandleB = handleB;
    }

    @Override
    public void prepare(@Nonnull Input input) {
        this.Input = input;
    }

    @Override
    public boolean canRun() {
        return this.Input != null;
    }

    @Override
    public void run() {
        if (this.Input != null) {
            TransformedBB boundsA = this.Input.ObjectA.getPendingBB();
            TransformedBB boundsB = this.Input.ObjectB.getPendingBB();
            for (ISeparationAxis separator : this.Input.ExistingSeparators) {
                if (!separator.separatesWithMotion(boundsA, this.Input.ObjectA.getLinearVelocity().applyOneTick(), boundsB, this.Input.ObjectB.getLinearVelocity().applyOneTick())) continue;
                this.Output = new Output((ImmutableList<DynamicCollisionEvent>)ImmutableList.of(), (ImmutableList<DynamicCollisionEvent>)ImmutableList.of(), null);
                return;
            }
            SeparationResult test = CollisionTasks.separate(boundsA, boundsB);
            if (test.success()) {
                this.Output = new Output((ImmutableList<DynamicCollisionEvent>)ImmutableList.of(), (ImmutableList<DynamicCollisionEvent>)ImmutableList.of(), (ImmutableList<ISeparationAxis>)ImmutableList.of((Object)test.separator()));
                return;
            }
            Optional<Vec3> collidingPoint = test.separator().linePlaneIntersect(boundsA.GetCenter(), boundsB.GetCenter());
            Vec3 pointInB = collidingPoint.orElse(boundsB.GetCenter());
            this.Output = new Output((ImmutableList<DynamicCollisionEvent>)ImmutableList.of((Object)new DynamicCollisionEvent(this.HandleB, pointInB, test.separator().getNormal().m_82490_(-1.0), test.depth())), (ImmutableList<DynamicCollisionEvent>)ImmutableList.of((Object)new DynamicCollisionEvent(this.HandleA, pointInB, test.separator().getNormal(), test.depth())), (ImmutableList<ISeparationAxis>)ImmutableList.of((Object)test.separator()));
        }
    }

    @Override
    public boolean canCancel() {
        return true;
    }

    @Override
    public void cancel() {
        this.Cancelled = true;
    }

    @Override
    public boolean isComplete() {
        return this.Cancelled || this.Output != null;
    }

    @Override
    @Nullable
    public Output getResult() {
        return this.Output;
    }

    public record Input(@Nonnull ICollisionAccessDynamicObject ObjectA, @Nonnull ICollisionAccessDynamicObject ObjectB, @Nonnull ImmutableList<ISeparationAxis> ExistingSeparators) {
    }

    public record Output(@Nonnull ImmutableList<DynamicCollisionEvent> EventsA, @Nonnull ImmutableList<DynamicCollisionEvent> EventsB, @Nullable ImmutableList<ISeparationAxis> NewSeparatorList) {
    }
}

