/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.deprecated;

import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.deprecated.ContinuousSeparationManifold;
import com.flansmod.physics.common.util.Transform;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;

public class ContinuousCollisionUtility {
    static final Vec3 uA0 = new Vec3(1.0, 0.0, 0.0);
    static final Vec3 uA1 = new Vec3(0.0, 1.0, 0.0);
    static final Vec3 uA2 = new Vec3(0.0, 0.0, 1.0);

    @Nullable
    public static ContinuousSeparationManifold SeparateContinuous(@Nonnull TransformedBB a, @Nonnull Vec3 motionA, @Nonnull AABB b) {
        return ContinuousCollisionUtility.SeparateContinuous(a.HalfExtents(), new Vector3f((float)b.m_82362_() / 2.0f, (float)b.m_82376_() / 2.0f, (float)b.m_82385_() / 2.0f), a.Loc(), Transform.fromPos(b.m_82399_()), motionA, Vec3.f_82478_);
    }

    @Nullable
    public static ContinuousSeparationManifold SeparateContinuous(@Nonnull TransformedBB a, @Nonnull Vec3 motionA, @Nonnull Vec3 posB, @Nonnull AABB sizeB) {
        return ContinuousCollisionUtility.SeparateContinuous(a.HalfExtents(), new Vector3f((float)sizeB.m_82362_() / 2.0f, (float)sizeB.m_82376_() / 2.0f, (float)sizeB.m_82385_() / 2.0f), a.Loc(), Transform.fromPos(posB.m_82549_(sizeB.m_82399_())), motionA, Vec3.f_82478_);
    }

    @Nullable
    public static ContinuousSeparationManifold SeparateContinuous(@Nonnull Vector3f halfA, @Nonnull Vector3f halfB, @Nonnull Transform locA, @Nonnull Transform locB, @Nonnull Vec3 localMotionA, @Nonnull Vec3 localMotionB) {
        Transform AtoB = locA.globalToLocalTransform(locB);
        return ContinuousCollisionUtility.SeparateContinuous(halfA, halfB, localMotionA.m_82549_(AtoB.localToGlobalVelocity(localMotionB)), AtoB);
    }

    @Nullable
    public static ContinuousSeparationManifold SeparateContinuous(@Nonnull Vector3f halfA, @Nonnull Vector3f halfB, @Nonnull Vec3 motionA, @Nonnull Transform AtoB) {
        Vec3 t = AtoB.positionVec3();
        Matrix3f m = AtoB.oriMatrix();
        Matrix3f maxMatrix = new Matrix3f(Math.abs(m.m00), Math.abs(m.m01), Math.abs(m.m02), Math.abs(m.m10), Math.abs(m.m11), Math.abs(m.m12), Math.abs(m.m20), Math.abs(m.m21), Math.abs(m.m22));
        Vec3 uB0 = new Vec3((double)m.m00, (double)m.m10, (double)m.m20);
        Vec3 uB1 = new Vec3((double)m.m01, (double)m.m11, (double)m.m21);
        Vec3 uB2 = new Vec3((double)m.m02, (double)m.m12, (double)m.m22);
        ContinuousSeparationSelector selector = new ContinuousSeparationSelector(uB1);
        Vector3f halfBMax = halfB.mul((Matrix3fc)maxMatrix, new Vector3f());
        if (selector.Try(t.f_82479_, halfA.x, halfBMax.x, motionA.f_82479_, true, () -> uA0)) {
            return null;
        }
        if (selector.Try(t.f_82480_, halfA.y, halfBMax.y, motionA.f_82480_, true, () -> uA1)) {
            return null;
        }
        if (selector.Try(t.f_82481_, halfA.z, halfBMax.z, motionA.f_82481_, true, () -> uA2)) {
            return null;
        }
        Vec3 tBRelative = AtoB.globalToLocalPosition(Vec3.f_82478_);
        Vec3 motionBRelative = AtoB.globalToLocalDirection(motionA);
        Vector3f halfAMax = halfA.mul((Matrix3fc)maxMatrix, new Vector3f());
        if (selector.Try(tBRelative.f_82479_, halfAMax.x, halfB.x, motionBRelative.f_82479_, false, () -> uB0)) {
            return null;
        }
        if (selector.Try(tBRelative.f_82480_, halfAMax.y, halfB.y, motionBRelative.f_82480_, false, () -> uB1)) {
            return null;
        }
        if (selector.Try(tBRelative.f_82481_, halfAMax.z, halfB.z, motionBRelative.f_82481_, false, () -> uB2)) {
            return null;
        }
        return selector.Build();
    }

    private static class ContinuousSeparationSelector {
        @Nonnull
        private Vec3 Axis = Vec3.f_82478_;
        private double Separation = Double.MAX_VALUE;
        private double LatestCollisionEntryTime = ContinuousSeparationManifold.UNDEFINED;
        private double EarliestCollisionExitTime = Double.MAX_VALUE;
        private boolean IsDiscrete = true;
        @Nonnull
        private Vec3 CollisionPosition = Vec3.f_82478_;
        @Nonnull
        private Vec3 StepSeparationAxis;
        private double StepSeparation;
        @Nonnull
        private Vec3 NormalSeparationAxis;
        private double NormalSeparation;

        public ContinuousSeparationSelector(@Nonnull Vec3 defaultUpAxis) {
            this.StepSeparationAxis = defaultUpAxis;
            this.StepSeparation = Double.MAX_VALUE;
            this.NormalSeparationAxis = Vec3.f_82478_;
            this.NormalSeparation = Double.MAX_VALUE;
        }

        public boolean Try(double dist, double radiusA, double radiusB, double projectedMotion, boolean axisOfObjA, @Nonnull Supplier<Vec3> axisProvider) {
            double dot;
            boolean isBestSeperation;
            boolean discreteCollision;
            double distance = Math.abs(dist);
            double diff = distance - (radiusA + radiusB);
            double sTL = Math.signum(dist);
            boolean bl = discreteCollision = diff <= 0.0;
            if (!discreteCollision && Math.signum(projectedMotion) == sTL) {
                return true;
            }
            double separation = sTL * Math.abs(diff);
            double entryTime = 0.0;
            double exitTime = Double.MAX_VALUE;
            if (!discreteCollision) {
                this.IsDiscrete = false;
                if (Math.abs(separation) > Math.abs(projectedMotion)) {
                    return true;
                }
                entryTime = Math.abs(separation) / Math.abs(projectedMotion);
                exitTime = (diff + Math.abs(radiusA) + Math.abs(radiusB)) / Math.abs(projectedMotion);
                this.LatestCollisionEntryTime = Math.max(entryTime, this.LatestCollisionEntryTime);
                this.EarliestCollisionExitTime = Math.min(exitTime, this.EarliestCollisionExitTime);
            }
            Vec3 newAxis = axisProvider.get();
            Vec3 newAxisNormalized = newAxis.m_82541_();
            boolean bl2 = isBestSeperation = distance != 0.0 && -diff <= Math.abs(this.Separation);
            if (axisOfObjA && distance != 0.0 && -diff <= Math.abs(this.NormalSeparation)) {
                this.NormalSeparationAxis = newAxisNormalized;
                this.NormalSeparation = separation;
            }
            if ((dot = this.StepSeparationAxis.m_82526_(newAxis)) != 0.0 && discreteCollision) {
                Vec3 cross = newAxis.m_82537_(this.StepSeparationAxis);
                double dotSeparation = Math.signum(dot) * dist - (radiusA + radiusB);
                double stepSeparation = -dotSeparation;
                Vec3 stepSeparationVec = newAxis;
                if (!cross.equals((Object)Vec3.f_82478_)) {
                    Vec3 sepVec = newAxisNormalized.m_82490_(dotSeparation);
                    Vec3 axisPlane = newAxis.m_82537_(cross);
                    Vec3 stepPlane = this.StepSeparationAxis.m_82537_(cross);
                    stepSeparationVec = sepVec.m_82546_(axisPlane.m_82490_(sepVec.m_82526_(stepPlane) / axisPlane.m_82526_(stepPlane)));
                    stepSeparation = stepSeparationVec.m_82553_();
                    if (Math.abs(this.StepSeparation) > Math.abs(stepSeparation) && stepSeparation != 0.0) {
                        this.StepSeparation = stepSeparation;
                    }
                } else if (Math.abs(this.StepSeparation) > stepSeparation) {
                    this.StepSeparation = stepSeparation;
                }
            }
            if (isBestSeperation) {
                this.Axis = newAxisNormalized;
                this.Separation = separation;
                this.CollisionPosition = newAxisNormalized.m_82490_(Math.signum(dist) * (axisOfObjA ? -radiusB : -radiusB) - Math.signum(separation) * 0.125);
            }
            return false;
        }

        @Nonnull
        public ContinuousSeparationManifold Build() {
            return new ContinuousSeparationManifold(this.Axis, this.Separation, this.LatestCollisionEntryTime, this.EarliestCollisionExitTime, this.IsDiscrete, this.CollisionPosition, this.StepSeparationAxis, this.StepSeparation, this.NormalSeparationAxis, this.NormalSeparation);
        }
    }
}

