/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.entity;

import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.collision.ICollisionSystem;
import com.flansmod.physics.common.entity.PhysicsComponent;
import com.flansmod.physics.common.util.ITransformEntity;
import com.flansmod.physics.common.util.ITransformPair;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.network.PhysicsPacketHandler;
import com.flansmod.physics.network.PhysicsSyncMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public abstract class PhysicsEntity
extends Entity
implements ITransformEntity {
    public static final double DEFAULT_PHYSICS_RANGE = 128.0;
    public static final UUID CORE_PHYSICS = new UUID(-4576008520733900674L, -4576008520733900674L);
    private boolean physicsActive = false;
    private Map<UUID, PhysicsComponent> physicsComponents = new HashMap<UUID, PhysicsComponent>();
    private boolean scheduledFullPhysicsUpdate = false;
    public double physicsRange = 128.0;

    public PhysicsEntity(@Nonnull EntityType<?> type, @Nonnull Level level) {
        super(type, level);
    }

    public void forEachPhysicsComponent(@Nonnull Consumer<PhysicsComponent> action) {
        for (PhysicsComponent component : this.physicsComponents.values()) {
            action.accept(component);
        }
    }

    public void forEachPhysicsComponent(@Nonnull BiConsumer<UUID, PhysicsComponent> action) {
        for (Map.Entry<UUID, PhysicsComponent> kvp : this.physicsComponents.entrySet()) {
            action.accept(kvp.getKey(), kvp.getValue());
        }
    }

    @Nonnull
    public PhysicsComponent getRootComponent() {
        return this.physicsComponents.getOrDefault(CORE_PHYSICS, PhysicsComponent.invalid);
    }

    @Nullable
    public PhysicsComponent getComponent(@Nonnull UUID componentID) {
        return this.physicsComponents.get(componentID);
    }

    @Nonnull
    public PhysicsComponent getComponentOrDefault(@Nonnull UUID componentID) {
        return this.physicsComponents.getOrDefault(componentID, PhysicsComponent.invalid);
    }

    @Nonnull
    public Transform getCurrentRootTransform() {
        return this.getRootComponent().getCurrentTransform();
    }

    @Nonnull
    public Transform getPreviousRootTransform() {
        return this.getRootComponent().getPreviousTransform();
    }

    @Override
    public void syncTransformToEntity() {
        Transform worldRoot = this.getRootComponent().getCurrentTransform();
        Vector3f euler = worldRoot.euler();
        this.m_146884_(worldRoot.positionVec3());
        this.f_19859_ = euler.y;
        this.f_19860_ = euler.x;
        this.m_146926_(euler.x);
        this.m_146922_(euler.y);
    }

    @Override
    public void syncEntityToTransform() {
        Transform coreTransformNew = Transform.fromPosAndEuler(this.m_20318_(0.0f), this.m_146909_(), this.m_146908_(), 0.0f);
        this.teleportTo(coreTransformNew);
    }

    @Override
    @Nonnull
    public ITransformPair getRootTransform() {
        return ITransformPair.of(this::getPreviousRootTransform, this::getCurrentRootTransform);
    }

    @Override
    public void teleportTo(@Nonnull Transform coreTransformNew) {
        PhysicsComponent corePart = this.getRootComponent();
        Transform coreTransformOld = corePart.getCurrentTransform();
        ICollisionSystem physics = FlansPhysicsMod.forLevel(this.m_9236_());
        HashMap newPartPositions = new HashMap();
        for (Map.Entry<UUID, PhysicsComponent> kvp : this.physicsComponents.entrySet()) {
            if (kvp.getKey().equals(CORE_PHYSICS)) continue;
            Transform relativeTransformOld = coreTransformOld.globalToLocalTransform(kvp.getValue().getCurrentTransform());
            Transform partTransformNew = coreTransformNew.localToGlobalTransform(relativeTransformOld);
            kvp.getValue().teleportTo(physics, partTransformNew);
        }
    }

    @Nonnull
    protected Transform getEntityRootAsTransform() {
        return Transform.fromEntity(this);
    }

    public void m_142687_(@Nonnull Entity.RemovalReason reason) {
        this.stopPhysics();
        this.unregisterAllPhysics();
        super.m_142687_(reason);
    }

    public void onRemovedFromWorld() {
        this.stopPhysics();
        this.unregisterAllPhysics();
        super.onRemovedFromWorld();
    }

    protected abstract void tickPhysics();

    protected abstract void tickOutsidePhysicsRange();

    protected void initPhysics() {
        this.addPhysicsComponent(CORE_PHYSICS, this.getEntityRootAsTransform(), List.of(new AABB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5)), 1.0);
    }

    protected void stopPhysics() {
    }

    protected void addPhysicsComponent(@Nonnull UUID id, @Nonnull PhysicsComponent component) {
        this.physicsComponents.put(id, component);
    }

    protected void addPhysicsComponent(@Nonnull UUID id, @Nonnull Transform worldPos, @Nonnull List<AABB> aabbs, double mass) {
        ICollisionSystem physics = FlansPhysicsMod.forLevel(this.m_9236_());
        this.physicsComponents.put(id, new PhysicsComponent(worldPos, this.m_9236_().m_46467_(), physics.registerDynamic(aabbs, worldPos, mass)));
    }

    protected void addPhysicsComponent(@Nonnull UUID id, @Nonnull Transform worldPos, @Nonnull List<AABB> aabbs, double mass, @Nonnull Vec3 momentOfInertia) {
        ICollisionSystem physics = FlansPhysicsMod.forLevel(this.m_9236_());
        this.physicsComponents.put(id, new PhysicsComponent(worldPos, this.m_9236_().m_46467_(), physics.registerDynamic(aabbs, worldPos, mass, momentOfInertia)));
    }

    protected void unregisterAllPhysics() {
        ICollisionSystem physics = FlansPhysicsMod.forLevel(this.m_9236_());
        for (PhysicsComponent component : this.physicsComponents.values()) {
            physics.unregisterDynamic(component.getPhysicsHandle());
        }
        this.physicsComponents.clear();
    }

    public void m_8119_() {
        super.m_8119_();
        this.checkPhysicsActivate();
        if (this.physicsActive) {
            ICollisionSystem physics = FlansPhysicsMod.forLevel(this.m_9236_());
            if (this.m_6109_()) {
                for (PhysicsComponent component : this.physicsComponents.values()) {
                    component.syncCollisionToComponent(physics);
                }
                this.syncTransformToEntity();
                this.sendPhysicsSync();
                this.tickPhysics();
                for (PhysicsComponent component : this.physicsComponents.values()) {
                    component.syncComponentToCollision(physics);
                }
            } else {
                for (PhysicsComponent component : this.physicsComponents.values()) {
                    component.syncAndLerpToComponent(physics);
                }
                this.syncTransformToEntity();
                this.tickPhysics();
                for (PhysicsComponent component : this.physicsComponents.values()) {
                    component.syncComponentToCollision(physics);
                }
            }
        } else {
            this.tickOutsidePhysicsRange();
        }
    }

    private void checkPhysicsActivate() {
        if (this.physicsActive) {
            boolean shouldDeactivate = false;
            if (!this.m_6084_()) {
                shouldDeactivate = true;
            }
            ICollisionSystem physics = FlansPhysicsMod.forLevel(this.m_9236_());
            for (PhysicsComponent component : this.physicsComponents.values()) {
                if (!physics.isHandleInvalidated(component.getPhysicsHandle())) continue;
                shouldDeactivate = true;
            }
            if (shouldDeactivate) {
                this.stopPhysics();
                for (PhysicsComponent component : this.physicsComponents.values()) {
                    physics.unregisterDynamic(component.getPhysicsHandle());
                }
                this.physicsComponents.clear();
                this.physicsActive = false;
            }
        } else {
            boolean shouldActivate = true;
            if (!this.m_6084_()) {
                shouldActivate = false;
            }
            if (shouldActivate) {
                this.physicsActive = true;
                this.initPhysics();
                if (!this.physicsComponents.containsKey(CORE_PHYSICS)) {
                    FlansPhysicsMod.LOGGER.error("initPhysics on entity " + this + " did not add a core physics component");
                }
            }
        }
    }

    private void sendPhysicsSync() {
        if (this.m_9236_().f_46443_) {
            PhysicsPacketHandler.sendToServer(this.createSyncMessage(new PhysicsSyncMessage.ToServer()));
        } else {
            PhysicsPacketHandler.sendToAllAroundPoint(this.createSyncMessage(new PhysicsSyncMessage.ToClient()), (ResourceKey<Level>)this.m_9236_().m_46472_(), this.m_20182_(), 100.0, null);
        }
    }

    @Nonnull
    private PhysicsSyncMessage createSyncMessage(@Nonnull PhysicsSyncMessage message) {
        message.EntityID = this.m_19879_();
        message.GameTick = this.m_9236_().m_46467_();
        this.forEachPhysicsComponent((UUID id, PhysicsComponent physicsComponent) -> {
            if (this.scheduledFullPhysicsUpdate || physicsComponent.needsUpdate()) {
                message.addStateChange((UUID)id, physicsComponent.getCurrentTransform(), physicsComponent.getCurrentLinearVelocity(), physicsComponent.getCurrentAngularVelocity());
            }
        });
        return message;
    }

    public void handleSyncMessage(@Nonnull PhysicsSyncMessage syncMessage) {
        if (this.m_6109_()) {
            return;
        }
        for (PhysicsSyncMessage.PhysicsStateChange stateChange : syncMessage.StateChanges) {
            PhysicsComponent component = this.getComponent(stateChange.PhysicsComponentID);
            if (component == null) continue;
            component.receiveUpdate(syncMessage.GameTick, stateChange);
        }
    }
}

