/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.units;

import com.flansmod.physics.common.units.AngularVelocity;
import com.flansmod.physics.common.units.IAcceleration;
import com.flansmod.physics.common.units.LinearAcceleration;
import com.flansmod.physics.common.units.Torque;
import com.flansmod.physics.common.units.Units;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;

public record AngularAcceleration(@Nonnull Vec3 Axis, double Magnitude) implements IAcceleration
{
    public static final AngularAcceleration Zero = new AngularAcceleration(new Vec3(0.0, 1.0, 0.0), 0.0);

    @Nonnull
    public static AngularAcceleration fromQuatPerTickSq(@Nonnull Quaternionf quaternionPerTick) {
        if (quaternionPerTick.equals((Quaternionfc)Transform.IDENTITY.Orientation, 1.0E-6f)) {
            return Zero;
        }
        AxisAngle4f axisAngle = new AxisAngle4f().set((Quaternionfc)quaternionPerTick);
        return new AngularAcceleration(new Vec3((double)axisAngle.x, (double)axisAngle.y, (double)axisAngle.z), axisAngle.angle);
    }

    @Nonnull
    public static AngularAcceleration fromQuatPerSecondSq(@Nonnull Quaternionf quaternionPerSecond) {
        return AngularAcceleration.fromQuatPerTickSq(quaternionPerSecond).scale(0.0025000000000000005);
    }

    @Nonnull
    public static AngularAcceleration radiansPerSecondSq(@Nonnull Vec3 axis, double radsPerSecSq) {
        return new AngularAcceleration(axis, Units.AngularAcceleration.Convert(radsPerSecSq, Units.AngularAcceleration.RadiansPerSecondSq, Units.AngularAcceleration.RadiansPerTickSq));
    }

    @Nonnull
    public static AngularAcceleration radiansPerTickSq(@Nonnull Vec3 axis, double radsPerTickSq) {
        return new AngularAcceleration(axis, radsPerTickSq);
    }

    @Nonnull
    public static AngularAcceleration degreesPerSecondSq(@Nonnull Vec3 axis, double degsPerSecSq) {
        return new AngularAcceleration(axis, Units.AngularAcceleration.Convert(degsPerSecSq, Units.AngularAcceleration.DegreesPerSecondSq, Units.AngularAcceleration.RadiansPerTickSq));
    }

    @Nonnull
    public static AngularAcceleration degreesPerTickSq(@Nonnull Vec3 axis, double degsPerTickSq) {
        return new AngularAcceleration(axis, Units.AngularAcceleration.Convert(degsPerTickSq, Units.AngularAcceleration.DegreesPerTickSq, Units.AngularAcceleration.RadiansPerTickSq));
    }

    @Nonnull
    public static AngularAcceleration fromUtoVinTicks(@Nonnull AngularVelocity u, @Nonnull AngularVelocity v, int ticks) {
        if (ticks == 0) {
            return Zero;
        }
        Quaternionf uPerT = new Quaternionf().setAngleAxis(u.Magnitude(), u.Axis().f_82479_, u.Axis().f_82480_, u.Axis().f_82481_);
        Quaternionf vPerT = new Quaternionf().setAngleAxis(v.Magnitude(), v.Axis().f_82479_, v.Axis().f_82480_, v.Axis().f_82481_);
        uPerT.invert();
        Quaternionf composed = vPerT.mul((Quaternionfc)uPerT);
        return AngularAcceleration.fromQuatPerTickSq(composed).scale(1.0 / (double)ticks);
    }

    @Nonnull
    public AngularAcceleration scale(double scale) {
        return new AngularAcceleration(this.Axis, this.Magnitude * scale);
    }

    @Nonnull
    public Torque asTorqueForPointMass(double mass) {
        return new Torque(this.Axis, this.Magnitude * mass);
    }

    @Nonnull
    public Torque asTorqueForSpinMass(@Nonnull Vec3 momentOfInertia) {
        AxisAngle4d axisAngle = new AxisAngle4d();
        Quaterniond quat = new Quaterniond();
        Vector3d euler = new Vector3d();
        quat.setAngleAxis(this.Magnitude, this.Axis.f_82479_, this.Axis.f_82480_, this.Axis.f_82481_);
        quat.getEulerAnglesXYZ(euler);
        euler.mul(momentOfInertia.f_82479_, momentOfInertia.f_82480_, momentOfInertia.f_82481_);
        quat.identity();
        quat.rotateXYZ(euler.x, euler.y, euler.z);
        axisAngle.set((Quaterniondc)quat);
        return new Torque(new Vec3(axisAngle.x, axisAngle.y, axisAngle.z), axisAngle.angle);
    }

    @Nonnull
    public Units.AngularAcceleration getDefaultUnits() {
        return Units.AngularAcceleration.RadiansPerTickSq;
    }

    public double getInUnits(@Nonnull Units.AngularAcceleration toUnit) {
        return Units.AngularAcceleration.Convert(this.Magnitude, Units.AngularAcceleration.RadiansPerTickSq, toUnit);
    }

    @Nonnull
    public AngularVelocity applyOverTicks(double ticks) {
        return new AngularVelocity(this.Axis, this.Magnitude * ticks);
    }

    @Nonnull
    public AngularVelocity applyOneTick() {
        return new AngularVelocity(this.Axis, this.Magnitude);
    }

    @Nonnull
    public AngularAcceleration compose(@Nonnull AngularAcceleration other) {
        Quaternionf angularA = new Quaternionf().setAngleAxis(this.Magnitude, this.Axis.f_82479_, this.Axis.f_82480_, this.Axis.f_82481_);
        Quaternionf angularB = new Quaternionf().setAngleAxis(other.Magnitude, other.Axis.f_82479_, other.Axis.f_82480_, other.Axis.f_82481_);
        Quaternionf composed = angularA.mul((Quaternionfc)angularB);
        return AngularAcceleration.fromQuatPerTickSq(composed);
    }

    @Override
    public boolean isApproxZero() {
        return Maths.approx(this.Magnitude, 0.0);
    }

    @Override
    @Nonnull
    public AngularAcceleration inverse() {
        return new AngularAcceleration(this.Axis, -this.Magnitude);
    }

    @Override
    public boolean hasLinearComponent(@Nonnull Transform actingOn) {
        return false;
    }

    @Override
    @Nonnull
    public LinearAcceleration getLinearComponent(@Nonnull Transform actingOn) {
        return LinearAcceleration.Zero;
    }

    @Override
    public boolean hasAngularComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public AngularAcceleration getAngularComponent(@Nonnull Transform actingOn) {
        return this;
    }

    public boolean IsApproxZero() {
        return Maths.approx(this.Magnitude, 0.0);
    }

    @Override
    public String toString() {
        return "AngularAcceleration [" + Units.Angle.Radians_To_Degrees(this.Magnitude) + "] degrees/tick^2 around [" + this.Axis + "]";
    }

    @Override
    @Nonnull
    public Component toFancyString() {
        return Component.m_237110_((String)"flansphysics.angular_acceleration", (Object[])new Object[]{Units.Angle.Radians_To_Degrees(this.Magnitude), this.Axis.f_82479_, this.Axis.f_82480_, this.Axis.f_82481_});
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AngularAcceleration) {
            AngularAcceleration otherAngularA = (AngularAcceleration)other;
            return otherAngularA.Axis.equals((Object)this.Axis) && Maths.approx(this.Magnitude, otherAngularA.Magnitude);
        }
        return false;
    }

    public boolean isApprox(@Nonnull AngularAcceleration other) {
        return Maths.approx(other.Axis, this.Axis) && Maths.approx(other.Magnitude, this.Magnitude);
    }

    public boolean isApprox(@Nonnull AngularAcceleration other, double epsilon) {
        return Maths.approx(other.Axis, this.Axis, epsilon) && Maths.approx(other.Magnitude, this.Magnitude, epsilon);
    }
}

