/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.units;

import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.units.IVelocity;
import com.flansmod.physics.common.units.LinearVelocity;
import com.flansmod.physics.common.units.Units;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public record AngularVelocity(@Nonnull Vec3 Axis, double Magnitude) implements IVelocity
{
    public static final AngularVelocity Zero = new AngularVelocity(new Vec3(0.0, 1.0, 0.0), 0.0);

    @Nonnull
    public static AngularVelocity fromQuatPerTick(@Nonnull Quaternionf quaternionPerTick) {
        if (quaternionPerTick.equals((Quaternionfc)Transform.IDENTITY.Orientation, 1.0E-6f)) {
            return Zero;
        }
        float acos = Math.safeAcos((float)quaternionPerTick.w);
        float invSqrt = Math.invsqrt((float)(1.0f - quaternionPerTick.w * quaternionPerTick.w));
        if (Float.isInfinite(invSqrt) || Float.isNaN(invSqrt)) {
            return Zero;
        }
        return new AngularVelocity(new Vec3((double)(quaternionPerTick.x * invSqrt), (double)(quaternionPerTick.y * invSqrt), (double)(quaternionPerTick.z * invSqrt)), acos + acos).checkNaN();
    }

    @Nonnull
    public static AngularVelocity fromQuatPerSecond(@Nonnull Quaternionf quaternionPerSecond) {
        return AngularVelocity.fromQuatPerTick(quaternionPerSecond).scale(0.05).checkNaN();
    }

    @Nonnull
    public static AngularVelocity radiansPerSecond(@Nonnull Vec3 axis, double radiansPerSecond) {
        return new AngularVelocity(axis, Units.AngularSpeed.RadiansPerSecond_To_RadiansPerTick(radiansPerSecond)).checkNaN();
    }

    @Nonnull
    public static AngularVelocity radiansPerSecond(@Nonnull Vec3 axisAngle) {
        double mag = axisAngle.m_82553_();
        if (mag < 1.0E-7) {
            return Zero;
        }
        Vec3 axis = axisAngle.m_82490_(1.0 / mag);
        return new AngularVelocity(axis, Units.AngularSpeed.RadiansPerSecond_To_RadiansPerTick(mag)).checkNaN();
    }

    @Nonnull
    public static AngularVelocity radiansPerSecond(@Nonnull AxisAngle4f radiansPerSecond) {
        return new AngularVelocity(new Vec3((double)radiansPerSecond.x, (double)radiansPerSecond.y, (double)radiansPerSecond.z), Units.AngularSpeed.RadiansPerSecond_To_RadiansPerTick(radiansPerSecond.angle)).checkNaN();
    }

    @Nonnull
    public static AngularVelocity radiansPerTick(@Nonnull Vec3 axis, double radiansPerTick) {
        return new AngularVelocity(axis, radiansPerTick).checkNaN();
    }

    @Nonnull
    public static AngularVelocity radiansPerTick(@Nonnull Vec3 axisAngle) {
        double mag = axisAngle.m_82553_();
        if (mag < 1.0E-7) {
            return Zero;
        }
        Vec3 axis = axisAngle.m_82490_(1.0 / mag);
        return new AngularVelocity(axis, mag).checkNaN();
    }

    @Nonnull
    public static AngularVelocity radiansPerTick(@Nonnull AxisAngle4f radiansPerTick) {
        return new AngularVelocity(new Vec3((double)radiansPerTick.x, (double)radiansPerTick.y, (double)radiansPerTick.z), radiansPerTick.angle).checkNaN();
    }

    @Nonnull
    public static AngularVelocity degreesPerSecond(@Nonnull Vec3 axis, double degressPerSecond) {
        return new AngularVelocity(axis, Units.AngularSpeed.DegreesPerSecond_To_RadiansPerTick(degressPerSecond)).checkNaN();
    }

    @Nonnull
    public static AngularVelocity degreesPerSecond(@Nonnull Vec3 axisAngle) {
        double mag = axisAngle.m_82553_();
        if (mag < 1.0E-7) {
            return Zero;
        }
        Vec3 axis = axisAngle.m_82490_(1.0 / mag);
        return new AngularVelocity(axis, Units.AngularSpeed.DegreesPerSecond_To_RadiansPerTick(mag)).checkNaN();
    }

    @Nonnull
    public Vec3 asVec3() {
        return this.Axis.m_82490_(this.Magnitude);
    }

    @Nonnull
    public AngularVelocity compose(@Nonnull AngularVelocity other) {
        Vec3 scaledA = this.asVec3();
        Vec3 scaledB = other.asVec3();
        return AngularVelocity.radiansPerTick(scaledA.m_82549_(scaledB));
    }

    @Nonnull
    public static AngularVelocity average(AngularVelocity ... velocities) {
        if (velocities.length == 0) {
            return Zero;
        }
        Vec3 angleAxisSum = Vec3.f_82478_;
        for (AngularVelocity v : velocities) {
            angleAxisSum = angleAxisSum.m_82549_(v.Axis.m_82490_(v.Magnitude));
        }
        return AngularVelocity.radiansPerTick(angleAxisSum.m_82490_(1.0 / (double)velocities.length));
    }

    @Nonnull
    public AngularVelocity lerp(@Nonnull AngularVelocity other, float t) {
        Quaternionf angularA = new Quaternionf().setAngleAxis(this.Magnitude, this.Axis.f_82479_, this.Axis.f_82480_, this.Axis.f_82481_);
        Quaternionf angularB = new Quaternionf().setAngleAxis(other.Magnitude, other.Axis.f_82479_, other.Axis.f_82480_, other.Axis.f_82481_);
        Quaternionf slerp = angularA.slerp((Quaternionfc)angularB, t);
        return AngularVelocity.fromQuatPerTick(slerp);
    }

    @Nonnull
    public static AngularVelocity interpolate(@Nonnull AngularVelocity a, @Nonnull AngularVelocity b, float t) {
        return a.lerp(b, t);
    }

    @Nonnull
    public AngularVelocity scale(double scale) {
        return new AngularVelocity(this.Axis, this.Magnitude * scale).checkNaN();
    }

    @Nonnull
    public LinearVelocity atOffset(@Nonnull Vec3 v) {
        if (Maths.approx(v, Vec3.f_82478_)) {
            return LinearVelocity.Zero;
        }
        Vec3 dir = this.Axis.m_82537_(v.m_82541_());
        double mag = this.Magnitude * v.m_82553_();
        return new LinearVelocity(dir.m_82490_(mag));
    }

    @Nonnull
    public Units.AngularSpeed getDefaultUnits() {
        return Units.AngularSpeed.RadiansPerTick;
    }

    @Nonnull
    public AngularVelocity convertToUnits(@Nonnull Units.AngularSpeed toUnits) {
        return new AngularVelocity(this.Axis, Units.AngularSpeed.Convert(this.Magnitude, Units.AngularSpeed.RadiansPerTick, toUnits));
    }

    @Nonnull
    public Quaternionf applyOverTicks(double ticks) {
        Quaternionf result = new Quaternionf().setAngleAxis(this.Magnitude * ticks, this.Axis.f_82479_, this.Axis.f_82480_, this.Axis.f_82481_);
        if (!Maths.approx(result.lengthSquared(), 1.0f)) {
            return Transform.IDENTITY.Orientation;
        }
        return result;
    }

    @Nonnull
    public Quaternionf applyOneTick() {
        Quaternionf result = new Quaternionf().setAngleAxis(this.Magnitude, this.Axis.f_82479_, this.Axis.f_82480_, this.Axis.f_82481_);
        if (!Maths.approx(result.lengthSquared(), 1.0f)) {
            return Transform.IDENTITY.Orientation;
        }
        return result;
    }

    @Override
    @Nonnull
    public AngularVelocity inverse() {
        return new AngularVelocity(this.Axis, -this.Magnitude);
    }

    @Override
    public boolean isApproxZero() {
        return Maths.approx(this.Magnitude, 0.0);
    }

    @Override
    public boolean hasLinearComponent(@Nonnull Transform actingOn) {
        return false;
    }

    @Override
    @Nonnull
    public LinearVelocity getLinearComponent(@Nonnull Transform actingOn) {
        return LinearVelocity.Zero;
    }

    @Override
    public boolean hasAngularComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public AngularVelocity getAngularComponent(@Nonnull Transform actingOn) {
        return this;
    }

    @Override
    public String toString() {
        return "AngularVelocity [" + Units.Angle.Radians_To_Degrees(this.Magnitude) + "] degrees/tick around [" + this.Axis + "]";
    }

    @Override
    @Nonnull
    public Component toFancyString() {
        return Component.m_237110_((String)"flansphysics.angular_velocity", (Object[])new Object[]{Units.Angle.Radians_To_Degrees(this.Magnitude), this.Axis.f_82479_, this.Axis.f_82480_, this.Axis.f_82481_});
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AngularVelocity) {
            AngularVelocity otherAngularV = (AngularVelocity)other;
            return otherAngularV.Axis.equals((Object)this.Axis) && Maths.approx(this.Magnitude, otherAngularV.Magnitude);
        }
        return false;
    }

    public boolean isApprox(@Nonnull AngularVelocity other) {
        return Maths.approx(other.Axis, this.Axis) && Maths.approx(other.Magnitude, this.Magnitude);
    }

    public boolean isApprox(@Nonnull AngularVelocity other, double epsilon) {
        return Maths.approx(other.Axis, this.Axis, epsilon) && Maths.approx(other.Magnitude, this.Magnitude, epsilon);
    }

    @Nonnull
    private AngularVelocity checkNaN() {
        if (this.isNaN()) {
            FlansPhysicsMod.LOGGER.error("AngularVelocity is NaN");
        }
        return this;
    }

    public boolean isNaN() {
        return Double.isNaN(this.Magnitude) || Double.isNaN(this.Axis.f_82479_) || Double.isNaN(this.Axis.f_82480_) || Double.isNaN(this.Axis.f_82481_);
    }

    public void toBuf(@Nonnull FriendlyByteBuf buf) {
        buf.m_269582_(this.Axis.m_252839_());
        buf.writeFloat((float)this.Magnitude);
    }

    @Nonnull
    public static AngularVelocity fromBuf(@Nonnull FriendlyByteBuf buf) {
        Vec3 axis = new Vec3(buf.m_269394_());
        double mag = buf.readFloat();
        return new AngularVelocity(axis, mag);
    }
}

