/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.units;

import com.flansmod.physics.common.units.AngularVelocity;
import com.flansmod.physics.common.units.IVelocity;
import com.flansmod.physics.common.units.LinearVelocity;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;

public record CompoundVelocity(@Nonnull LinearVelocity linear, @Nonnull AngularVelocity angular) implements IVelocity
{
    public static final CompoundVelocity Zero = new CompoundVelocity(LinearVelocity.Zero, AngularVelocity.Zero);

    @Nonnull
    public static CompoundVelocity of(@Nonnull LinearVelocity linear, @Nonnull AngularVelocity angular) {
        return new CompoundVelocity(linear, angular);
    }

    @Nonnull
    public LinearVelocity linearAtPoint(@Nonnull Vec3 offset) {
        return this.angular.atOffset(offset).add(this.linear);
    }

    @Nonnull
    public CompoundVelocity compose(@Nonnull CompoundVelocity other) {
        return new CompoundVelocity(this.linear.add(other.linear), this.angular.compose(other.angular));
    }

    @Override
    @Nonnull
    public CompoundVelocity inverse() {
        return new CompoundVelocity(this.linear.inverse(), this.angular.inverse());
    }

    @Override
    public boolean isApproxZero() {
        return this.linear.isApproxZero() && this.angular.isApproxZero();
    }

    @Override
    public boolean hasLinearComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public LinearVelocity getLinearComponent(@Nonnull Transform actingOn) {
        return this.linear;
    }

    @Override
    public boolean hasAngularComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public AngularVelocity getAngularComponent(@Nonnull Transform actingOn) {
        return this.angular;
    }

    @Override
    public String toString() {
        return "CompoundVelocity [" + this.linear + "] at [" + this.angular + "]";
    }

    @Override
    @Nonnull
    public Component toFancyString() {
        return Component.m_237110_((String)"flansphysics.compound_velocity", (Object[])new Object[]{this.linear.Velocity().f_82479_, this.linear.Velocity().f_82480_, this.linear.Velocity().f_82481_, this.angular.Magnitude(), this.angular.Axis().f_82479_, this.angular.Axis().f_82480_, this.angular.Axis().f_82481_});
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof CompoundVelocity) {
            CompoundVelocity otherCompound = (CompoundVelocity)other;
            return otherCompound.linear.equals(this.linear) && otherCompound.angular.equals(this.angular);
        }
        return false;
    }

    public boolean isApprox(@Nonnull CompoundVelocity other) {
        return this.linear.isApprox(other.linear) && this.angular.isApprox(other.angular);
    }

    public boolean isApprox(@Nonnull CompoundVelocity other, double epsilon) {
        return this.linear.isApprox(other.linear, epsilon) && this.angular.isApprox(other.angular, epsilon);
    }

    @Nonnull
    public static CompoundVelocity average(CompoundVelocity ... velocities) {
        LinearVelocity[] linears = new LinearVelocity[velocities.length];
        AngularVelocity[] angulars = new AngularVelocity[velocities.length];
        for (int i = 0; i < velocities.length; ++i) {
            linears[i] = velocities[i].linear;
            angulars[i] = velocities[i].angular;
        }
        return new CompoundVelocity(LinearVelocity.average(linears), AngularVelocity.average(angulars));
    }
}

