/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.units;

import com.flansmod.physics.common.units.IForce;
import com.flansmod.physics.common.units.LinearForce;
import com.flansmod.physics.common.units.OffsetAcceleration;
import com.flansmod.physics.common.units.Torque;
import com.flansmod.physics.common.units.Units;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public record OffsetForce(@Nonnull Vec3 Force, @Nonnull Vec3 Offset) implements IForce
{
    @Nonnull
    public static OffsetForce kgBlocksPerSecondSq(@Nonnull Vec3 kgBlocksPerSecSq, @Nonnull Vec3 offset) {
        return new OffsetForce(Units.Force.KgBlocksPerSecondSq_To_KgBlocksPerTickSq(kgBlocksPerSecSq), offset);
    }

    @Nonnull
    public static OffsetForce kgBlocksPerTickSq(@Nonnull Vec3 kgBlocksPerTickSq, @Nonnull Vec3 offset) {
        return new OffsetForce(kgBlocksPerTickSq, offset);
    }

    @Nonnull
    public static OffsetForce offset(@Nonnull LinearForce force, @Nonnull Vec3 offset) {
        return new OffsetForce(force.Force(), offset);
    }

    @Nonnull
    public Units.Force getDefaultUnits() {
        return Units.Force.KgBlocksPerTickSquared;
    }

    @Nonnull
    public Vec3 convertToUnits(@Nonnull Units.Force toUnits) {
        return Units.Force.Convert(this.Force, Units.Force.KgBlocksPerTickSquared, toUnits);
    }

    @Nonnull
    public OffsetAcceleration actingOn(double mass) {
        return new OffsetAcceleration(this.Force.m_82490_(1.0 / mass), this.Offset);
    }

    @Nonnull
    public Quaternionf getAngularComponentRadiansPerSecondSq(@Nonnull Transform actingOn) {
        return new Quaternionf();
    }

    @Override
    @Nonnull
    public OffsetForce inverse() {
        return new OffsetForce(this.Force.m_82490_(-1.0), this.Offset);
    }

    @Override
    public boolean isApproxZero() {
        return this.Force.m_82556_() < 9.999999999999998E-15;
    }

    @Override
    public boolean hasLinearComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public LinearForce getLinearComponent(@Nonnull Transform actingOn) {
        return new LinearForce(this.Force);
    }

    @Override
    public boolean hasAngularComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public Torque getTorqueComponent(@Nonnull Transform actingOn) {
        Vec3 relativeOffset = this.Offset.m_82546_(actingOn.positionVec3());
        Vec3 axis = relativeOffset.m_82537_(this.Force).m_82541_();
        double magnitude = this.Force.m_82553_() * relativeOffset.m_82553_();
        return new Torque(axis, magnitude);
    }

    @Override
    public String toString() {
        return "OffsetForce [" + this.Force + "] at [" + this.Offset + "]";
    }

    @Override
    @Nonnull
    public Component toFancyString() {
        return Component.m_237110_((String)"flansphysics.offset_force", (Object[])new Object[]{this.Force.f_82479_, this.Force.f_82480_, this.Force.f_82481_, this.Offset.f_82479_, this.Offset.f_82480_, this.Offset.f_82481_});
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof OffsetForce) {
            OffsetForce otherForce = (OffsetForce)other;
            return otherForce.Force.equals((Object)this.Force) && otherForce.Offset.equals((Object)this.Offset);
        }
        return false;
    }

    public boolean isApprox(@Nonnull OffsetForce other) {
        return Maths.approx(other.Force, this.Force) && Maths.approx(other.Offset, this.Offset);
    }

    public boolean isApprox(@Nonnull OffsetForce other, double epsilon) {
        return Maths.approx(other.Force, this.Force, epsilon) && Maths.approx(other.Offset, this.Offset, epsilon);
    }
}

