/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.util;

import com.flansmod.physics.common.util.Maths;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeltaRingBuffer<TData extends Comparable<TData>>
implements Iterable<TData> {
    private final Object[] elements;
    private int headIndex;
    private int numElements;

    public DeltaRingBuffer(int size, TData initialState) {
        this.elements = new Object[size];
        this.elements[0] = initialState;
        this.headIndex = 0;
        this.numElements = 1;
    }

    public void reset(TData initialState) {
        this.elements[0] = initialState;
        this.headIndex = 0;
        this.numElements = 1;
    }

    public int capacity() {
        return this.elements.length;
    }

    public int size() {
        return this.numElements;
    }

    @Nonnull
    public TData getMostRecent() {
        return (TData)((Comparable)this.elements[this.headIndex]);
    }

    @Nullable
    public TData getOldEntry(int depth) {
        int oldIndex;
        if (depth < this.numElements && this.elements[oldIndex = Maths.modulo(this.headIndex - depth, this.elements.length)] != null) {
            return (TData)((Comparable)this.elements[oldIndex]);
        }
        return null;
    }

    public void add(@Nonnull TData data) {
        ++this.numElements;
        ++this.headIndex;
        if (this.headIndex >= this.elements.length) {
            this.headIndex = 0;
        }
        this.elements[this.headIndex] = data;
    }

    @Nullable
    public TData removeLatest() {
        if (this.numElements > 1) {
            Object ret = this.elements[this.headIndex];
            this.elements[this.headIndex] = null;
            --this.numElements;
            --this.headIndex;
            if (this.headIndex < 0) {
                this.headIndex += this.elements.length;
            }
            return (TData)(ret == null ? null : (Comparable)ret);
        }
        return null;
    }

    public boolean addIfChanged(@Nonnull TData data) {
        TData head = this.getMostRecent();
        int comparison = head.compareTo(data);
        if (comparison == 0) {
            return false;
        }
        this.add(data);
        return true;
    }

    @Override
    @Nonnull
    public Iterator<TData> iterator() {
        return new Iterator<TData>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < DeltaRingBuffer.this.numElements;
            }

            @Override
            public TData next() {
                return DeltaRingBuffer.this.getOldEntry(this.idx++);
            }
        };
    }
}

