/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.util;

import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Maths {
    public static final double Root2 = Maths.sqrt(2.0);
    public static final double Epsilon = 1.0E-7;
    public static final double EpsilonSq = 9.999999999999998E-15;
    public static final float Root2F = Maths.sqrtF(2.0f);
    public static final float EpsilonF = 1.0E-6f;
    public static final double Pi = Math.PI;
    public static final double Tau = Math.PI * 2;
    public static final double DegToRad = Math.PI / 180;
    public static final double RadToDeg = 57.29577951308232;
    public static final float PiF = (float)Math.PI;
    public static final float TauF = (float)Math.PI * 2;
    public static final float DegToRadF = (float)Math.PI / 180;
    public static final float RadToDegF = 57.29578f;

    public static long max(long a, long b) {
        return a > b ? a : b;
    }

    public static long min(long a, long b) {
        return a < b ? a : b;
    }

    public static long ceilLerp(long a, long b, double t) {
        return Maths.ceilL((double)a + (double)(b - a) * t);
    }

    public static long floorLerp(long a, long b, double t) {
        return Maths.floorL((double)a + (double)(b - a) * t);
    }

    public static long roundLerp(long a, long b, double t) {
        return Maths.roundL((double)a + (double)(b - a) * t);
    }

    public static int modulo(int a, int b) {
        int c = a % b;
        if (c < 0) {
            c += b;
        }
        return c;
    }

    public static int abs(int a) {
        return a < 0 ? -a : a;
    }

    public static int clamp(int i, int min, int max) {
        return i > max ? max : (i < min ? min : i);
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static int ceilLerp(int a, int b, float t) {
        return Maths.ceil((float)a + (float)(b - a) * t);
    }

    public static int floorLerp(int a, int b, float t) {
        return Maths.floor((float)a + (float)(b - a) * t);
    }

    public static int roundLerp(int a, int b, float t) {
        return Maths.round((float)a + (float)(b - a) * t);
    }

    public static double abs(double a) {
        return a < 0.0 ? -a : a;
    }

    public static double clamp(double i, double min, double max) {
        return i > max ? max : (i < min ? min : i);
    }

    public static int ceil(double d) {
        return (int)Math.ceil(d);
    }

    public static int floor(double d) {
        return (int)Math.floor(d);
    }

    public static int round(double d) {
        return (int)Math.round(d);
    }

    public static long ceilL(double d) {
        return (long)Math.ceil(d);
    }

    public static long floorL(double d) {
        return (long)Math.floor(d);
    }

    public static long roundL(double d) {
        return Math.round(d);
    }

    public static double max(double a, double b) {
        return a > b ? a : b;
    }

    public static double min(double a, double b) {
        return a < b ? a : b;
    }

    public static boolean absApprox(double a, double b) {
        return Maths.approx(a, b) || Maths.approx(a, -b);
    }

    public static boolean absApprox(double a, double b, double epsilon) {
        return Maths.approx(a, b, epsilon) || Maths.approx(a, -b, epsilon);
    }

    public static boolean approx(double a, double b) {
        return Maths.abs(a - b) < 1.0E-7;
    }

    public static boolean approx(double a, double b, double epsilon) {
        return Maths.abs(a - b) < epsilon;
    }

    public static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    public static double sign(double d) {
        return d > 0.0 ? 1.0 : (d < 0.0 ? -1.0 : 0.0);
    }

    public static double exp(double d) {
        return Math.exp(d);
    }

    public static double pow(double a, double b) {
        return Math.pow(a, b);
    }

    public static float clamp(float i, float min, float max) {
        return i > max ? max : (i < min ? min : i);
    }

    public static float abs(float a) {
        return a < 0.0f ? -a : a;
    }

    public static float max(float a, float b) {
        return a > b ? a : b;
    }

    public static float max(float a, float b, float c) {
        return Maths.max(Maths.max(a, b), c);
    }

    public static float min(float a, float b) {
        return a < b ? a : b;
    }

    public static int ceil(float d) {
        return (int)Math.ceil(d);
    }

    public static int floor(float d) {
        return (int)Math.floor(d);
    }

    public static int round(float d) {
        return Math.round(d);
    }

    public static boolean approx(float a, float b) {
        return Maths.abs(a - b) < 1.0E-6f;
    }

    public static boolean approx(float a, float b, float epsilon) {
        return Maths.abs(a - b) < epsilon;
    }

    public static float lerpF(float a, float b, float t) {
        return a + (b - a) * Maths.clamp(t, 0.0f, 1.0f);
    }

    public static float sign(float f) {
        return f > 0.0f ? 1.0f : (f < 0.0f ? -1.0f : 0.0f);
    }

    public static float expF(float f) {
        return (float)Math.exp(f);
    }

    public static float powF(float a, float b) {
        return (float)Math.pow(a, b);
    }

    public static double sin(double f) {
        return Math.sin(f);
    }

    public static double cos(double f) {
        return Math.cos(f);
    }

    public static double sqrt(double f) {
        return Math.sqrt(f);
    }

    public static double atan(double f) {
        return Math.atan(f);
    }

    public static double atan2(double a, double b) {
        return Math.atan2(a, b);
    }

    public static double fastInvSqrt(double d) {
        double xhalf = 0.5 * d;
        long i = Double.doubleToLongBits(d);
        i = 6910470738111508698L - (i >> 1);
        d = Double.longBitsToDouble(i);
        d *= 1.5 - xhalf * d * d;
        return d;
    }

    public static float sinF(float f) {
        return (float)Math.sin(f);
    }

    public static float cosF(float f) {
        return (float)Math.cos(f);
    }

    public static float sqrtF(float f) {
        return (float)Math.sqrt(f);
    }

    public static float atanF(float f) {
        return (float)Math.atan(f);
    }

    public static float atan2F(float a, float b) {
        return (float)Math.atan2(a, b);
    }

    public static Vector3f lerp(Vector3f a, Vector3f b, float t) {
        return new Vector3f(a.x + (b.x - a.x) * t, a.y + (b.y - a.y) * t, a.z + (b.z - a.z) * t);
    }

    public static Vector3f sub(Vector3f a, Vector3f b) {
        return new Vector3f(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public static Vector3f add(Vector3f a, Vector3f b) {
        return new Vector3f(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public static Vector3f cross(Vector3f a, Vector3f b) {
        return a.cross((Vector3fc)b, new Vector3f());
    }

    public static Vector3f identityPosF() {
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public static Vector3d lerp(Vector3d a, Vector3d b, float t) {
        return new Vector3d(a.x + (b.x - a.x) * (double)t, a.y + (b.y - a.y) * (double)t, a.z + (b.z - a.z) * (double)t);
    }

    public static Vector3d sub(Vector3d a, Vector3d b) {
        return new Vector3d(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public static Vector3d add(Vector3d a, Vector3d b) {
        return new Vector3d(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public static Vector3d cross(Vector3d a, Vector3d b) {
        return a.cross((Vector3dc)b, new Vector3d());
    }

    public static Vector3d identityPosD() {
        return new Vector3d(0.0, 0.0, 0.0);
    }

    public static Vec3 lerp(Vec3 a, Vec3 b, float t) {
        return new Vec3(a.f_82479_ + (b.f_82479_ - a.f_82479_) * (double)t, a.f_82480_ + (b.f_82480_ - a.f_82480_) * (double)t, a.f_82481_ + (b.f_82481_ - a.f_82481_) * (double)t);
    }

    public static Vec3 sub(Vec3 a, Vec3 b) {
        return new Vec3(a.f_82479_ - b.f_82479_, a.f_82480_ - b.f_82480_, a.f_82481_ - b.f_82481_);
    }

    public static Vec3 add(Vec3 a, Vec3 b) {
        return new Vec3(a.f_82479_ + b.f_82479_, a.f_82480_ + b.f_82480_, a.f_82481_ + b.f_82481_);
    }

    public static Vec3 cross(Vec3 a, Vec3 b) {
        return a.m_82537_(b);
    }

    public static double lengthSqr(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public static double lengthXYZ(Vec3 v) {
        return v.m_82553_();
    }

    public static double lengthXZ(Vec3 v) {
        return Maths.sqrt(v.f_82479_ * v.f_82479_ + v.f_82481_ * v.f_82481_);
    }

    public static boolean approx(Vec3 a, Vec3 b) {
        return (a.f_82479_ - b.f_82479_) * (a.f_82479_ - b.f_82479_) + (a.f_82480_ - b.f_82480_) * (a.f_82480_ - b.f_82480_) + (a.f_82481_ - b.f_82481_) * (a.f_82481_ - b.f_82481_) < 9.999999999999998E-15;
    }

    public static boolean approx(Vec3 a, Vec3 b, double epsilon) {
        return (a.f_82479_ - b.f_82479_) * (a.f_82479_ - b.f_82479_) + (a.f_82480_ - b.f_82480_) * (a.f_82480_ - b.f_82480_) + (a.f_82481_ - b.f_82481_) * (a.f_82481_ - b.f_82481_) < epsilon * epsilon;
    }

    public static Vec3 clamp(Vec3 v, double min, double max) {
        return new Vec3(Maths.clamp(v.f_82479_, min, max), Maths.clamp(v.f_82480_, min, max), Maths.clamp(v.f_82481_, min, max));
    }

    public static Quaternionf slerp(Quaternionf a, Quaternionf b, float t) {
        return a.slerp((Quaternionfc)b, t, new Quaternionf());
    }

    public static float clampDegrees(float f) {
        if ((f %= 360.0f) >= 180.0f) {
            return f - 360.0f;
        }
        if (f < -180.0f) {
            return f + 360.0f;
        }
        return f;
    }

    public static float lerpDegrees(float a, float b, float t) {
        float delta = Maths.clampDegrees(b - a);
        return a + delta * t;
    }

    public static double calculateParameter(Vec3 v0, Vec3 v1, Vec3 vT) {
        double tX = (vT.f_82479_ - v0.f_82479_) / (v1.f_82479_ - v0.f_82479_);
        if (Double.isFinite(tX)) {
            return tX;
        }
        double tY = (vT.f_82480_ - v0.f_82480_) / (v1.f_82480_ - v0.f_82480_);
        if (Double.isFinite(tY)) {
            return tY;
        }
        double tZ = (vT.f_82481_ - v0.f_82481_) / (v1.f_82481_ - v0.f_82481_);
        if (Double.isFinite(tZ)) {
            return tZ;
        }
        return Double.NaN;
    }

    public static int blockPosToPinpointData(BlockPos pos, int extraData) {
        return (extraData & 0xFF) << 24 | (pos.m_123341_() & 0xFF) << 16 | (pos.m_123342_() & 0xFF) << 8 | pos.m_123343_() & 0xFF;
    }

    public static int getClosestDistanceModulo(int a, int b, int mod) {
        int delta = Maths.modulo(a - b, mod);
        int complement = delta - mod;
        return Maths.abs(complement) < Maths.abs(delta) ? complement : delta;
    }

    public static Vec3 reflect(Vec3 incident, Direction surface) {
        switch (surface) {
            case UP: 
            case DOWN: {
                return new Vec3(incident.f_82479_, -incident.f_82480_, incident.f_82481_);
            }
            case NORTH: 
            case SOUTH: {
                return new Vec3(incident.f_82479_, incident.f_82480_, -incident.f_82481_);
            }
            case EAST: 
            case WEST: {
                return new Vec3(-incident.f_82479_, incident.f_82480_, incident.f_82481_);
            }
        }
        return incident;
    }

    public static BlockPos resolveBlockPos(BlockPos roughGuess, int pinpointData) {
        int xMod256 = roughGuess.m_123341_() & 0xFF;
        int yMod256 = roughGuess.m_123342_() & 0xFF;
        int zMod256 = roughGuess.m_123343_() & 0xFF;
        int xPin = pinpointData >> 16 & 0xFF;
        int yPin = pinpointData >> 8 & 0xFF;
        int zPin = pinpointData & 0xFF;
        int dx = Maths.getClosestDistanceModulo(xMod256, xPin, 256);
        int dy = Maths.getClosestDistanceModulo(yMod256, yPin, 256);
        int dz = Maths.getClosestDistanceModulo(zMod256, zPin, 256);
        return new BlockPos(roughGuess.m_123341_() + dx, roughGuess.m_123342_() + dy, roughGuess.m_123343_() + dz);
    }

    public static String toRomanNumerals(int n) {
        StringBuilder builder = new StringBuilder();
        if (n >= 10000) {
            builder.append(n / 1000).append('M');
        } else {
            while (n >= 1000) {
                builder.append("M");
                n -= 1000;
            }
        }
        n = Maths.generateNumeralsForPow10(n, builder, 100, 'M', 'D', 'C');
        n = Maths.generateNumeralsForPow10(n, builder, 10, 'C', 'L', 'X');
        n = Maths.generateNumeralsForPow10(n, builder, 1, 'X', 'V', 'I');
        return builder.toString();
    }

    private static int generateNumeralsForPow10(int n, StringBuilder builder, int pow10, char ten, char five, char one) {
        if (n >= pow10 * 9) {
            builder.append(one).append(ten);
            n -= pow10 * 9;
        } else if (n >= pow10 * 5) {
            builder.append(five);
            while (n >= pow10 * 6) {
                builder.append(one);
                n -= pow10;
            }
            n -= pow10 * 5;
        } else if (n >= pow10 * 4) {
            builder.append(one).append(five);
            n -= pow10 * 4;
        } else {
            while (n >= pow10) {
                builder.append(one);
                n -= pow10;
            }
        }
        return n;
    }

    public static boolean rayBoxIntersect(@Nonnull Vec3 startPos, @Nonnull Vec3 endPos, @Nonnull Transform boxCenterTransform, @Nonnull Vector3f boxHalfExtents, @Nullable Vector3d outPos) {
        double intersectX;
        double intersectZ;
        double intersectTime;
        startPos = boxCenterTransform.globalToLocalPosition(startPos);
        endPos = boxCenterTransform.globalToLocalPosition(endPos);
        Vec3 motion = endPos.m_82546_(startPos);
        if (motion.f_82479_ != 0.0) {
            if (startPos.f_82479_ < (double)(-boxHalfExtents.x)) {
                intersectTime = ((double)(-boxHalfExtents.x) - startPos.f_82479_) / motion.f_82479_;
                intersectY = startPos.f_82480_ + motion.f_82480_ * intersectTime;
                intersectZ = startPos.f_82481_ + motion.f_82481_ * intersectTime;
                if ((double)(-boxHalfExtents.y) <= intersectY && intersectY <= (double)boxHalfExtents.y && (double)(-boxHalfExtents.z) <= intersectZ && intersectZ <= (double)boxHalfExtents.z) {
                    if (outPos != null) {
                        Vec3 globalIntersect = boxCenterTransform.localToGlobalPosition(new Vec3((double)(-boxHalfExtents.x), intersectY, intersectZ));
                        outPos.set(globalIntersect.f_82479_, globalIntersect.f_82480_, globalIntersect.f_82481_);
                    }
                    return true;
                }
            } else if (startPos.f_82479_ > (double)boxHalfExtents.x) {
                intersectTime = ((double)boxHalfExtents.x - startPos.f_82479_) / motion.f_82479_;
                intersectY = startPos.f_82480_ + motion.f_82480_ * intersectTime;
                intersectZ = startPos.f_82481_ + motion.f_82481_ * intersectTime;
                if ((double)(-boxHalfExtents.y) <= intersectY && intersectY <= (double)boxHalfExtents.y && (double)(-boxHalfExtents.z) <= intersectZ && intersectZ <= (double)boxHalfExtents.z) {
                    if (outPos != null) {
                        Vec3 globalIntersect = boxCenterTransform.localToGlobalPosition(new Vec3((double)boxHalfExtents.x, intersectY, intersectZ));
                        outPos.set(globalIntersect.f_82479_, globalIntersect.f_82480_, globalIntersect.f_82481_);
                    }
                    return true;
                }
            }
        }
        if (motion.f_82481_ != 0.0) {
            if (startPos.f_82481_ < (double)(-boxHalfExtents.z)) {
                intersectTime = ((double)(-boxHalfExtents.z) - startPos.f_82481_) / motion.f_82481_;
                intersectX = startPos.f_82479_ + motion.f_82479_ * intersectTime;
                intersectY = startPos.f_82480_ + motion.f_82480_ * intersectTime;
                if ((double)(-boxHalfExtents.x) <= intersectX && intersectX <= (double)boxHalfExtents.x && (double)(-boxHalfExtents.y) <= intersectY && intersectY <= (double)boxHalfExtents.y) {
                    if (outPos != null) {
                        Vec3 globalIntersect = boxCenterTransform.localToGlobalPosition(new Vec3(intersectX, intersectY, (double)(-boxHalfExtents.z)));
                        outPos.set(globalIntersect.f_82479_, globalIntersect.f_82480_, globalIntersect.f_82481_);
                    }
                    return true;
                }
            } else if (startPos.f_82481_ > (double)boxHalfExtents.z) {
                intersectTime = ((double)boxHalfExtents.z - startPos.f_82481_) / motion.f_82481_;
                intersectX = startPos.f_82479_ + motion.f_82479_ * intersectTime;
                intersectY = startPos.f_82480_ + motion.f_82480_ * intersectTime;
                if ((double)(-boxHalfExtents.x) <= intersectX && intersectX <= (double)boxHalfExtents.x && (double)(-boxHalfExtents.y) <= intersectY && intersectY <= (double)boxHalfExtents.y) {
                    if (outPos != null) {
                        Vec3 globalIntersect = boxCenterTransform.localToGlobalPosition(new Vec3(intersectX, intersectY, (double)boxHalfExtents.z));
                        outPos.set(globalIntersect.f_82479_, globalIntersect.f_82480_, globalIntersect.f_82481_);
                    }
                    return true;
                }
            }
        }
        if (motion.f_82480_ != 0.0) {
            if (startPos.f_82480_ < (double)(-boxHalfExtents.y)) {
                intersectTime = ((double)(-boxHalfExtents.y) - startPos.f_82480_) / motion.f_82480_;
                intersectX = startPos.f_82479_ + motion.f_82479_ * intersectTime;
                intersectZ = startPos.f_82481_ + motion.f_82481_ * intersectTime;
                if ((double)(-boxHalfExtents.x) <= intersectX && intersectX <= (double)boxHalfExtents.x && (double)(-boxHalfExtents.z) <= intersectZ && intersectZ <= (double)boxHalfExtents.z) {
                    if (outPos != null) {
                        Vec3 globalIntersect = boxCenterTransform.localToGlobalPosition(new Vec3(intersectX, (double)(-boxHalfExtents.y), intersectZ));
                        outPos.set(globalIntersect.f_82479_, globalIntersect.f_82480_, globalIntersect.f_82481_);
                    }
                    return true;
                }
            } else if (startPos.f_82480_ > (double)boxHalfExtents.y) {
                intersectTime = ((double)boxHalfExtents.y - startPos.f_82480_) / motion.f_82480_;
                intersectX = startPos.f_82479_ + motion.f_82479_ * intersectTime;
                intersectZ = startPos.f_82481_ + motion.f_82481_ * intersectTime;
                if ((double)(-boxHalfExtents.x) <= intersectX && intersectX <= (double)boxHalfExtents.x && (double)(-boxHalfExtents.z) <= intersectZ && intersectZ <= (double)boxHalfExtents.z) {
                    if (outPos != null) {
                        Vec3 globalIntersect = boxCenterTransform.localToGlobalPosition(new Vec3(intersectX, (double)boxHalfExtents.y, intersectZ));
                        outPos.set(globalIntersect.f_82479_, globalIntersect.f_82480_, globalIntersect.f_82481_);
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

