/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.util;

import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.util.ProjectedRange;
import com.flansmod.physics.common.util.shapes.VertexIndex;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Vector3f;

public class ProjectionUtil {
    @Nonnull
    public static ProjectedRange ProjectAABBMinMax(@Nonnull Vec3 projAxis, @Nonnull AABB aabb) {
        return ProjectionUtil.ProjectAABBMinMax(projAxis, aabb.f_82288_, aabb.f_82289_, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
    }

    @Nonnull
    public static ProjectedRange ProjectAABBMinMax(@Nonnull Vec3 projAxis, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        double x1 = projAxis.f_82479_ * xMin;
        double x2 = projAxis.f_82479_ * xMax;
        double y1 = projAxis.f_82480_ * yMin;
        double y2 = projAxis.f_82480_ * yMax;
        double z1 = projAxis.f_82481_ * zMin;
        double z2 = projAxis.f_82481_ * zMax;
        return ProjectedRange.preSorted(Math.min(x1, x2) + Math.min(y1, y2) + Math.min(z1, z2), Math.max(x1, x2) + Math.max(y1, y2) + Math.max(z1, z2));
    }

    public static double ProjectAABBMax(@Nonnull Vec3 projAxis, @Nonnull AABB aabb) {
        return ProjectionUtil.ProjectAABBMax(projAxis, aabb.f_82288_, aabb.f_82289_, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
    }

    public static double ProjectAABBMax(@Nonnull Vec3 projAxis, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        return Math.max(projAxis.f_82479_ * xMin, projAxis.f_82479_ * xMax) + Math.max(projAxis.f_82480_ * yMin, projAxis.f_82480_ * yMax) + Math.max(projAxis.f_82481_ * zMin, projAxis.f_82481_ * zMax);
    }

    public static double ProjectAABBMin(@Nonnull Vec3 projAxis, @Nonnull AABB aabb) {
        return ProjectionUtil.ProjectAABBMin(projAxis, aabb.f_82288_, aabb.f_82289_, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
    }

    public static double ProjectAABBMin(@Nonnull Vec3 projAxis, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        return Math.min(projAxis.f_82479_ * xMin, projAxis.f_82479_ * xMax) + Math.min(projAxis.f_82480_ * yMin, projAxis.f_82480_ * yMax) + Math.min(projAxis.f_82481_ * zMin, projAxis.f_82481_ * zMax);
    }

    public static double ProjectBoxMin(@Nonnull Vec3 projAxis, @Nonnull Vec3 point, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        double projPosX = point.f_82479_ * projAxis.f_82479_;
        double orientedHalfX = (double)halfExtents.x * (projAxis.f_82479_ * (double)ori.m00 + projAxis.f_82480_ * (double)ori.m10 + projAxis.f_82481_ * (double)ori.m20);
        double minProjX = Math.min(projPosX + orientedHalfX, projPosX - orientedHalfX);
        double projPosY = point.f_82480_ * projAxis.f_82480_;
        double orientedHalfY = (double)halfExtents.y * (projAxis.f_82479_ * (double)ori.m01 + projAxis.f_82480_ * (double)ori.m11 + projAxis.f_82481_ * (double)ori.m21);
        double minProjY = Math.min(projPosY + orientedHalfY, projPosY - orientedHalfY);
        double projPosZ = point.f_82481_ * projAxis.f_82481_;
        double orientedHalfZ = (double)halfExtents.z * (projAxis.f_82479_ * (double)ori.m02 + projAxis.f_82480_ * (double)ori.m12 + projAxis.f_82481_ * (double)ori.m22);
        double minProjZ = Math.min(projPosZ + orientedHalfZ, projPosZ - orientedHalfZ);
        return minProjX + minProjY + minProjZ;
    }

    public static double ProjectBoxMax(@Nonnull Vec3 projAxis, @Nonnull Vec3 point, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        double projPosX = point.f_82479_ * projAxis.f_82479_;
        double orientedHalfX = (double)halfExtents.x * (projAxis.f_82479_ * (double)ori.m00 + projAxis.f_82480_ * (double)ori.m10 + projAxis.f_82481_ * (double)ori.m20);
        double maxProjX = Math.max(projPosX + orientedHalfX, projPosX - orientedHalfX);
        double projPosY = point.f_82480_ * projAxis.f_82480_;
        double orientedHalfY = (double)halfExtents.y * (projAxis.f_82479_ * (double)ori.m01 + projAxis.f_82480_ * (double)ori.m11 + projAxis.f_82481_ * (double)ori.m21);
        double maxProjY = Math.max(projPosY + orientedHalfY, projPosY - orientedHalfY);
        double projPosZ = point.f_82481_ * projAxis.f_82481_;
        double orientedHalfZ = (double)halfExtents.z * (projAxis.f_82479_ * (double)ori.m02 + projAxis.f_82480_ * (double)ori.m12 + projAxis.f_82481_ * (double)ori.m22);
        double maxProjZ = Math.max(projPosZ + orientedHalfZ, projPosZ - orientedHalfZ);
        return maxProjX + maxProjY + maxProjZ;
    }

    @Nonnull
    public static ProjectedRange ProjectOBBMinMax(@Nonnull Vec3 projAxis, @Nonnull TransformedBB obb) {
        return ProjectionUtil.ProjectOBBMinMax(projAxis, obb.GetCenter(), obb.HalfExtents(), obb.Loc().oriMatrix());
    }

    @Nonnull
    public static ProjectedRange ProjectOBBMinMax(@Nonnull Vec3 projAxis, @Nonnull Vec3 boxCenter, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        double projPosX = boxCenter.f_82479_ * projAxis.f_82479_;
        double orientedHalfX = (double)halfExtents.x * (projAxis.f_82479_ * (double)ori.m00 + projAxis.f_82480_ * (double)ori.m10 + projAxis.f_82481_ * (double)ori.m20);
        double maxProjX = Math.max(projPosX + orientedHalfX, projPosX - orientedHalfX);
        double minProjX = Math.min(projPosX + orientedHalfX, projPosX - orientedHalfX);
        double projPosY = boxCenter.f_82480_ * projAxis.f_82480_;
        double orientedHalfY = (double)halfExtents.y * (projAxis.f_82479_ * (double)ori.m01 + projAxis.f_82480_ * (double)ori.m11 + projAxis.f_82481_ * (double)ori.m21);
        double maxProjY = Math.max(projPosY + orientedHalfY, projPosY - orientedHalfY);
        double minProjY = Math.min(projPosY + orientedHalfY, projPosY - orientedHalfY);
        double projPosZ = boxCenter.f_82481_ * projAxis.f_82481_;
        double orientedHalfZ = (double)halfExtents.z * (projAxis.f_82479_ * (double)ori.m02 + projAxis.f_82480_ * (double)ori.m12 + projAxis.f_82481_ * (double)ori.m22);
        double maxProjZ = Math.max(projPosZ + orientedHalfZ, projPosZ - orientedHalfZ);
        double minProjZ = Math.min(projPosZ + orientedHalfZ, projPosZ - orientedHalfZ);
        return ProjectedRange.preSorted(minProjX + minProjY + minProjZ, maxProjX + maxProjY + maxProjZ);
    }

    public static double ProjectMaxVertexDelta(@Nonnull Vec3 projAxis, @Nonnull Vector3f halfExtents, @Nonnull Vec3 boxCenterA, @Nonnull Matrix3f oriA, @Nonnull Vec3 boxCenterB, @Nonnull Matrix3f oriB) {
        double linearProjection = (boxCenterB.f_82479_ - boxCenterA.f_82479_) * projAxis.f_82479_ + (boxCenterB.f_82480_ - boxCenterA.f_82480_) * projAxis.f_82480_ + (boxCenterB.f_82481_ - boxCenterA.f_82481_) * projAxis.f_82481_;
        double angularProjection = (double)halfExtents.x * (projAxis.f_82479_ * (double)(oriB.m00 - oriA.m00) + projAxis.f_82480_ * (double)(oriB.m10 - oriA.m10) + projAxis.f_82481_ * (double)(oriB.m20 - oriA.m20)) + (double)halfExtents.y * (projAxis.f_82479_ * (double)(oriB.m01 - oriA.m01) + projAxis.f_82480_ * (double)(oriB.m11 - oriA.m11) + projAxis.f_82481_ * (double)(oriB.m21 - oriA.m21)) + (double)halfExtents.z * (projAxis.f_82479_ * (double)(oriB.m02 - oriA.m02) + projAxis.f_82480_ * (double)(oriB.m12 - oriA.m12) + projAxis.f_82481_ * (double)(oriB.m22 - oriA.m22));
        return linearProjection + angularProjection;
    }

    @Nonnull
    public static VertexIndex SelectCornerOBBMin(@Nonnull Vec3 projAxis, @Nonnull Vec3 boxCenter, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        return ProjectionUtil.SelectCornerOBBMax(projAxis, boxCenter, halfExtents, ori).opposite();
    }

    @Nonnull
    public static VertexIndex SelectCornerOBBMax(@Nonnull Vec3 projAxis, @Nonnull Vec3 boxCenter, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        double orientedHalfX = (double)halfExtents.x * (projAxis.f_82479_ * (double)ori.m00 + projAxis.f_82480_ * (double)ori.m10 + projAxis.f_82481_ * (double)ori.m20);
        boolean positiveX = orientedHalfX > 0.0;
        double orientedHalfY = (double)halfExtents.y * (projAxis.f_82479_ * (double)ori.m01 + projAxis.f_82480_ * (double)ori.m11 + projAxis.f_82481_ * (double)ori.m21);
        boolean positiveY = orientedHalfY > 0.0;
        double orientedHalfZ = (double)halfExtents.z * (projAxis.f_82479_ * (double)ori.m02 + projAxis.f_82480_ * (double)ori.m12 + projAxis.f_82481_ * (double)ori.m22);
        boolean positiveZ = orientedHalfZ > 0.0;
        return VertexIndex.of(positiveX, positiveY, positiveZ);
    }

    public static double GetSeparationDistance(@Nonnull ProjectedRange a, @Nonnull ProjectedRange b) {
        if (a.min() >= b.max()) {
            return a.min() - b.max();
        }
        if (b.min() >= a.max()) {
            return b.min() - a.max();
        }
        return Math.max(a.min() - b.max(), b.min() - a.max());
    }

    public static double GetSeparationDistanceWithMotion(@Nonnull ProjectedRange a, double motionA, @Nonnull ProjectedRange b, double motionB) {
        return ProjectionUtil.GetSeparationDistance(ProjectedRange.preSorted(a.min() + motionA, a.max() + motionA), ProjectedRange.preSorted(b.min() + motionB, b.max() + motionB));
    }

    @Nonnull
    public static Pair<Double, ProjectionComparison> GetSeparationDistanceAndOrder(@Nonnull ProjectedRange a, @Nonnull ProjectedRange b) {
        double clipDepthBthenA;
        if (a.min() >= b.max()) {
            return Pair.of((Object)(a.min() - b.max()), (Object)((Object)ProjectionComparison.Separate_B_Then_A));
        }
        if (b.min() >= a.max()) {
            return Pair.of((Object)(b.min() - a.max()), (Object)((Object)ProjectionComparison.Separate_A_Then_B));
        }
        double clipDepthAthenB = b.min() - a.max();
        if (clipDepthAthenB > (clipDepthBthenA = a.min() - b.max())) {
            return Pair.of((Object)clipDepthAthenB, (Object)((Object)ProjectionComparison.Colliding_A_Then_B));
        }
        return Pair.of((Object)clipDepthBthenA, (Object)((Object)ProjectionComparison.Colliding_B_Then_A));
    }

    public static boolean SeparatedAThenB(@Nonnull ProjectedRange a, @Nonnull ProjectedRange b) {
        return a.max() <= b.min();
    }

    public static boolean SeparatedBThenA(@Nonnull ProjectedRange a, @Nonnull ProjectedRange b) {
        return b.max() <= a.min();
    }

    public static boolean Separated(@Nonnull ProjectedRange a, @Nonnull ProjectedRange b) {
        if (a.min() >= b.max()) {
            return true;
        }
        return b.min() >= a.max();
    }

    public static boolean SeparatedWithMotion(@Nonnull ProjectedRange a, double motionA, @Nonnull ProjectedRange b, double motionB) {
        if (a.min() + motionA >= b.max() + motionB) {
            return true;
        }
        return b.min() + motionB >= a.max() + motionA;
    }

    public static enum ProjectionComparison {
        Separate_A_Then_B,
        Separate_B_Then_A,
        Colliding_A_Then_B,
        Colliding_B_Then_A;

    }
}

