/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.util.shapes;

import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.shapes.IPlane;
import com.flansmod.physics.common.util.shapes.Plane;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.Vec3;

public interface IPolygon {
    @Nonnull
    public List<Vec3> getVertices();

    @Nonnull
    public IPolygon clip(@Nonnull IPlane var1);

    @Nonnull
    public IPolygon cullClip(@Nonnull IPlane var1);

    default public int GetNumVertices() {
        return this.getVertices().size();
    }

    @Nonnull
    default public Vec3 getVertex(int index) {
        if (0 <= index && index < this.getVertices().size()) {
            return this.getVertices().get(index);
        }
        return Vec3.f_82478_;
    }

    @Nonnull
    default public Vec3 getVertexLooped(int index) {
        if (this.getVertices().isEmpty()) {
            return Vec3.f_82478_;
        }
        index = Maths.modulo(index, this.getVertices().size());
        return this.getVertices().get(index);
    }

    @Nonnull
    default public Vec3 getEdgeVector(int edgeIndex) {
        Vec3 v1 = this.getVertexLooped(edgeIndex);
        Vec3 v2 = this.getVertexLooped(edgeIndex + 1);
        return v2.m_82546_(v1);
    }

    @Nonnull
    default public Vec3 getAveragePos() {
        int numVerts = this.getVertices().size();
        if (numVerts == 0) {
            return Vec3.f_82478_;
        }
        Vec3 pos = Vec3.f_82478_;
        for (int i = 0; i < numVerts; ++i) {
            pos = pos.m_82549_(this.getVertices().get(i));
        }
        return pos.m_82490_(1.0 / (double)numVerts);
    }

    default public double getArea() {
        int numVerts = this.getVertices().size();
        if (numVerts <= 2) {
            return 0.0;
        }
        double totalArea = 0.0;
        Vec3 v0 = this.getVertex(0);
        for (int i = 2; i < numVerts; ++i) {
            Vec3 v1 = this.getVertex(i - 1).m_82546_(v0);
            Vec3 v2 = this.getVertex(i).m_82546_(v0);
            totalArea += Maths.abs(v1.m_82526_(v2)) * 0.5;
        }
        return totalArea;
    }

    @Nonnull
    default public IPolygon clip(@Nonnull List<IPlane> clipPlanes) {
        IPolygon clipResult = this;
        for (IPlane clipPlane : clipPlanes) {
            clipResult = clipResult.clip(clipPlane);
        }
        return clipResult;
    }

    @Nonnull
    default public IPlane getEdgeClipPlane(@Nonnull Vec3 refNormal, int edgeIndex) {
        Vec3 edge = this.getEdgeVector(edgeIndex);
        refNormal = this.getEdgeVector(edgeIndex + 1).m_82541_();
        Vec3 clipNormal = refNormal.m_82537_(refNormal.m_82537_(edge.m_82541_()));
        double dist = this.getVertexLooped(edgeIndex).m_82526_(clipNormal);
        return Plane.of(clipNormal, dist);
    }

    @Nonnull
    default public IPlane getFaceClipPlane() {
        if (this.GetNumVertices() < 3) {
            FlansPhysicsMod.LOGGER.warn("Tried to get clip plane of a polygon with fewer than 3 verts");
            return Plane.of(Vec3.f_82478_, 0.0);
        }
        Vec3 v1 = this.getVertexLooped(0);
        Vec3 v2 = this.getVertexLooped(1);
        Vec3 v3 = this.getVertexLooped(2);
        Vec3 normal = v2.m_82546_(v1).m_82537_(v3.m_82546_(v1)).m_82541_();
        double dist = v1.m_82526_(normal);
        return Plane.of(normal, dist);
    }
}

