/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.util.shapes;

import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.shapes.IPlane;
import com.flansmod.physics.common.util.shapes.ISeparationAxis;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.Vec3;

public record Plane(@Nonnull Vec3 Normal, double Distance) implements IPlane
{
    @Nonnull
    public static Plane of(@Nonnull Vec3 normal, double distance) {
        return new Plane(normal, distance);
    }

    @Nonnull
    public static Plane ofNormalAndPointOnPlane(@Nonnull Vec3 normal, @Nonnull Vec3 point) {
        return new Plane(normal, point.m_82526_(normal));
    }

    @Nonnull
    public static Plane of(@Nonnull ISeparationAxis axis, double distance) {
        return new Plane(axis.getNormal(), distance);
    }

    @Override
    public double getDistance() {
        return this.Distance;
    }

    @Override
    @Nonnull
    public Vec3 getNormal() {
        return this.Normal;
    }

    @Override
    public double project(@Nonnull Vec3 point) {
        return point.m_82526_(this.Normal);
    }

    @Override
    @Nonnull
    public Optional<Vec3> rayPlaneIntersect(@Nonnull Vec3 origin, @Nonnull Vec3 ray) {
        double rDotV = ray.m_82526_(this.Normal);
        if (Maths.approx(rDotV, 0.0)) {
            return Optional.empty();
        }
        double oDotV = origin.m_82526_(this.Normal);
        double t = (this.Distance - oDotV) / rDotV;
        return Optional.of(origin.m_82549_(ray.m_82490_(t)));
    }
}

