/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.util.formulae;

import javax.annotation.Nonnull;

public class FloatAccumulation {
    public final float BaseAdd;
    public final float StackableMultiplier;
    public final float IndependentMultiplier;
    public final float FinalAdd;

    public float get() {
        return this.BaseAdd * (1.0f + this.StackableMultiplier) * this.IndependentMultiplier + this.FinalAdd;
    }

    public float apply(float baseValue) {
        return (baseValue + this.BaseAdd) * (1.0f + this.StackableMultiplier) * this.IndependentMultiplier + this.FinalAdd;
    }

    private FloatAccumulation(float baseAdd, float stackableMul, float independentMul, float finalAdd) {
        this.BaseAdd = baseAdd;
        this.StackableMultiplier = stackableMul;
        this.IndependentMultiplier = independentMul;
        this.FinalAdd = finalAdd;
    }

    @Nonnull
    public static FloatAccumulation of(float baseAdd, float stackableMul, float independentMul, float finalAdd) {
        return new FloatAccumulation(baseAdd, stackableMul, independentMul, finalAdd);
    }

    @Nonnull
    public static FloatAccumulation compose(FloatAccumulation ... mods) {
        float baseAdd = 0.0f;
        float stackableMul = 0.0f;
        float independentMul = 1.0f;
        float finalAdd = 0.0f;
        for (FloatAccumulation mod : mods) {
            baseAdd += mod.BaseAdd;
            stackableMul += mod.StackableMultiplier;
            independentMul *= mod.IndependentMultiplier;
            finalAdd += mod.FinalAdd;
        }
        return new FloatAccumulation(baseAdd, stackableMul, independentMul, finalAdd);
    }
}

