/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import com.github.talrey.createdeco.BlockRegistry;
import com.github.talrey.createdeco.blocks.CatwalkBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CatwalkStairBlock
extends Block
implements IWrenchable,
ProperWaterloggedBlock {
    public static final BooleanProperty RAILING_LEFT = BooleanProperty.m_61465_((String)"railing_left");
    public static final BooleanProperty RAILING_RIGHT = BooleanProperty.m_61465_((String)"railing_right");
    public final String metal;
    private static final VoxelShape BOX_NORTH = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape BOX_SOUTH = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape BOX_WEST = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)8.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape BOX_EAST = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)8.0, (double)6.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);

    public CatwalkStairBlock(BlockBehaviour.Properties props, String metal) {
        super(props);
        this.metal = metal;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RAILING_LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RAILING_RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean isCatwalkStair(ItemStack test) {
        BlockItem be;
        Item item = test.m_41720_();
        return item instanceof BlockItem && (be = (BlockItem)item).m_40614_() instanceof CatwalkStairBlock;
    }

    public static boolean isCatwalkStair(Block test) {
        return test instanceof CatwalkBlock || test instanceof CatwalkStairBlock;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_8125_();
        FluidState fluid = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing.m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        builder.m_61104_(new Property[]{RAILING_LEFT});
        builder.m_61104_(new Property[]{RAILING_RIGHT});
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && fluid == Fluids.f_76193_;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
            case Direction.SOUTH -> BOX_SOUTH;
            case Direction.EAST -> BOX_EAST;
            case Direction.WEST -> BOX_WEST;
            default -> BOX_NORTH;
        };
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Vec3 subbox = context.m_43720_().m_82546_(pos.m_252807_());
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (((Boolean)state.m_61143_((Property)RAILING_RIGHT)).booleanValue() || ((Boolean)state.m_61143_((Property)RAILING_LEFT)).booleanValue()) {
            double xPos = subbox.f_82479_;
            double zPos = subbox.f_82481_;
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            boolean left = false;
            if (dir == Direction.NORTH) {
                boolean bl = left = xPos > 0.0;
            }
            if (dir == Direction.SOUTH) {
                boolean bl = left = xPos < 0.0;
            }
            if (dir == Direction.EAST) {
                boolean bl = left = zPos > 0.0;
            }
            if (dir == Direction.WEST) {
                boolean bl = left = zPos < 0.0;
            }
            if (level.m_5776_() || !((Boolean)state.m_61143_((Property)(left ? RAILING_LEFT : RAILING_RIGHT))).booleanValue()) {
                return InteractionResult.PASS;
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)(left ? RAILING_LEFT : RAILING_RIGHT), (Comparable)Boolean.valueOf(false)), 3);
            if (!player.m_150110_().f_35937_) {
                player.m_36356_(new ItemStack((ItemLike)BlockRegistry.CATWALK_RAILINGS.get(this.metal)));
            }
            this.playRemoveSound(level, pos);
            return InteractionResult.SUCCESS;
        }
        level.m_7471_(pos, false);
        if (!player.m_150110_().f_35937_) {
            player.m_36356_(new ItemStack((ItemLike)state.m_60734_().m_5456_()));
        }
        this.playRemoveSound(level, pos);
        return InteractionResult.SUCCESS;
    }
}

