/*
 * Decompiled with CFR 0.152.
 */
package net.mysticdrew.journeymapteams.handlers;

import net.minecraft.world.entity.player.Player;
import net.mysticdrew.journeymapteams.handlers.Handler;
import net.mysticdrew.journeymapteams.handlers.properties.DefaultHandlerProperties;
import net.mysticdrew.journeymapteams.handlers.properties.Properties;

public abstract class AbstractHandler
implements Handler {
    protected final Properties properties;

    public AbstractHandler(String categoryToken, String categoryKey) {
        this.properties = new DefaultHandlerProperties(categoryToken, categoryKey);
    }

    public AbstractHandler(Properties properties) {
        this.properties = properties;
    }

    @Override
    public int getRemotePlayerNameColor(Player remotePlayer, int currentColor) {
        if (this.properties.getShowNameColor()) {
            return this.getRemotePlayerColor(remotePlayer);
        }
        return currentColor;
    }

    @Override
    public int getRemotePlayerIconColor(Player remotePlayer, int currentColor) {
        if (this.properties.getShowIconColor()) {
            return this.getRemotePlayerColor(remotePlayer);
        }
        return currentColor;
    }

    public int getColor(boolean teammates, boolean allied, int teamColor) {
        if (allied) {
            return this.properties.getForceAllyColor() ? this.properties.getAllyColor() : teamColor;
        }
        if (teammates) {
            return this.properties.getForceTeamColor() ? this.properties.getTeamColor() : teamColor;
        }
        return this.properties.getTeamColor();
    }

    protected abstract int getRemotePlayerColor(Player var1);
}

