/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.config.provider;

import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.config.provider.BuiltInProviderConfig;
import net.lionarius.skinrestorer.config.provider.CacheConfig;
import net.lionarius.skinrestorer.util.gson.GsonPostProcessable;

public class MineskinProviderConfig
implements BuiltInProviderConfig,
GsonPostProcessable {
    private static final CacheConfig DEFAULT_CACHE_VALUE = new CacheConfig(true, 300L);
    private boolean enabled = true;
    private String name = "web";
    private CacheConfig cache = DEFAULT_CACHE_VALUE;
    private String apiKey = "";

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public CacheConfig cache() {
        return this.cache;
    }

    public String apiKey() {
        return this.apiKey;
    }

    @Override
    public void gsonPostProcess() {
        if (this.name == null || this.name.isEmpty()) {
            SkinRestorer.LOGGER.warn("Mineskin provider name is null or empty, defaulting to '{}'", (Object)"web");
            this.name = "web";
        }
        if (this.cache == null) {
            SkinRestorer.LOGGER.warn("Mineskin cache is null, using default");
            this.cache = DEFAULT_CACHE_VALUE;
        } else {
            this.cache.validate(DEFAULT_CACHE_VALUE);
        }
        if (this.apiKey == null) {
            SkinRestorer.LOGGER.warn("Mineskin API key is null, defaulting to an empty string");
            this.apiKey = "";
        }
    }
}

