/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.skin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.properties.Property;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.UUID;
import net.lionarius.skinrestorer.skin.SkinValue;
import net.lionarius.skinrestorer.skin.SkinVariant;
import net.lionarius.skinrestorer.util.FileUtils;
import net.lionarius.skinrestorer.util.JsonUtils;

public class SkinIO {
    public static final String FILE_EXTENSION = ".json";
    private final Path savePath;

    public SkinIO(Path savePath) {
        this.savePath = savePath;
    }

    public boolean skinExists(UUID uuid) {
        return Files.exists(this.savePath.resolve(SkinIO.uuidToFilename(uuid)), new LinkOption[0]);
    }

    public SkinValue loadSkin(UUID uuid) {
        try {
            return SkinIO.loadSkin(this.savePath.resolve(SkinIO.uuidToFilename(uuid)));
        }
        catch (Exception e) {
            return SkinValue.EMPTY;
        }
    }

    private static SkinValue loadSkin(Path file) {
        String json = FileUtils.readFile(file);
        try {
            return JsonUtils.fromJson(json, SkinValue.class);
        }
        catch (Exception e) {
            Property property = JsonUtils.fromJson(json, Property.class);
            return SkinIO.convertFromOldFormat(property);
        }
    }

    public void saveSkin(UUID uuid, SkinValue skin) {
        FileUtils.writeFile(this.savePath.resolve(SkinIO.uuidToFilename(uuid)), JsonUtils.toJson(skin));
    }

    public void deleteSkin(UUID uuid) {
        FileUtils.deleteFile(this.savePath.resolve(SkinIO.uuidToFilename(uuid)));
    }

    private static String uuidToFilename(UUID uuid) {
        return uuid + FILE_EXTENSION;
    }

    private static SkinValue convertFromOldFormat(Property property) {
        try {
            JsonElement model;
            JsonObject propertyJson = Objects.requireNonNull(JsonUtils.skinPropertyToJson(property));
            JsonObject textures = propertyJson.getAsJsonObject("textures");
            JsonObject capeTexture = textures.getAsJsonObject("CAPE");
            if (capeTexture != null) {
                String profileName = propertyJson.get("profileName").getAsString();
                return new SkinValue("mojang", profileName, null, property);
            }
            JsonObject skinTexture = textures.getAsJsonObject("SKIN");
            String url = skinTexture.get("url").getAsString();
            SkinVariant variant = SkinVariant.CLASSIC;
            JsonObject metadata = skinTexture.getAsJsonObject("metadata");
            if (metadata != null && (model = metadata.get("model")) != null && "slim".equals(model.getAsString())) {
                variant = SkinVariant.SLIM;
            }
            return new SkinValue("web", url, variant, property);
        }
        catch (Exception e) {
            return SkinValue.EMPTY;
        }
    }
}

