/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.zlt.create_vibrant_vaults.block.entity.AbstractItemVaultBlockEntity;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractItemVaultBlock<BE extends AbstractItemVaultBlockEntity<BE>>
extends Block
implements IWrenchable,
IBE<BE> {
    public static final Property<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.f_61364_;
    public static final BooleanProperty LARGE = ItemVaultBlock.LARGE;
    public static final SoundType SILENCED_METAL = ItemVaultBlock.SILENCED_METAL;

    public AbstractItemVaultBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LARGE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HORIZONTAL_AXIS, LARGE});
        super.m_7926_(pBuilder);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState placedOn;
        Direction.Axis preferredAxis;
        if (!(pContext.m_43723_() != null && pContext.m_43723_().m_6144_() || (preferredAxis = this.getVaultBlockAxis(placedOn = pContext.m_43725_().m_8055_(pContext.m_8083_().m_121945_(pContext.m_43719_().m_122424_())))) == null)) {
            return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_AXIS, (Comparable)preferredAxis);
        }
        return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_AXIS, (Comparable)pContext.m_8125_().m_122434_());
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (pOldState.m_60734_() != pState.m_60734_() && !pMovedByPiston) {
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, AbstractItemVaultBlockEntity::updateConnectivity);
        }
    }

    @Nullable
    protected abstract BE getAsBE(BlockEntity var1);

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.m_43719_().m_122434_().m_122478_()) {
            AbstractItemVaultBlockEntity be;
            BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
            AbstractItemVaultBlockEntity abstractItemVaultBlockEntity = be = blockEntity == null ? null : (AbstractItemVaultBlockEntity)((Object)this.getAsBE(blockEntity));
            if (be != null) {
                ConnectivityHandler.splitMulti(be);
                be.removeController(true);
            }
            state = (BlockState)state.m_61124_((Property)LARGE, (Comparable)Boolean.valueOf(false));
        }
        return this.defaultOnWrenched(state, context);
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (targetedFace.m_122434_().m_122478_()) {
            return super.getRotatedBlockState(originalState, targetedFace);
        }
        if (originalState.m_61138_(HORIZONTAL_AXIS) && targetedFace.m_122434_() != originalState.m_61143_(HORIZONTAL_AXIS)) {
            Block vertical = this.getVerticalVaultBlock();
            return vertical == null ? originalState : vertical.m_49966_();
        }
        return originalState;
    }

    @javax.annotation.Nullable
    public Block getVerticalVaultBlock() {
        return null;
    }

    protected InteractionResult defaultOnWrenched(BlockState state, UseOnContext context) {
        return super.onWrenched(state, context);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean pIsMoving) {
        if (state.m_155947_() && (state.m_60734_() != newState.m_60734_() || !newState.m_155947_())) {
            BlockEntity be;
            BlockEntity blockEntity = world.m_7702_(pos);
            BlockEntity blockEntity2 = be = blockEntity == null ? null : (BlockEntity)this.getAsBE(blockEntity);
            if (be != null) {
                ItemHelper.dropContents((Level)world, (BlockPos)pos, (IItemHandler)be.inventory);
                world.m_46747_(pos);
                ConnectivityHandler.splitMulti(be);
            }
        }
    }

    public abstract boolean isVault(BlockState var1);

    @javax.annotation.Nullable
    public Direction.Axis getVaultBlockAxis(BlockState state) {
        return !this.isVault(state) ? null : (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
    }

    public boolean isLarge(BlockState state) {
        return this.isVault(state) && (Boolean)state.m_61143_((Property)LARGE) != false;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_(HORIZONTAL_AXIS, (Comparable)rot.m_55954_(Direction.m_122387_((Direction.Axis)((Direction.Axis)state.m_61143_(HORIZONTAL_AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).m_122434_());
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state;
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        return entity != null && entity.getPersistentData().m_128441_("SilenceVaultSound") ? SILENCED_METAL : super.getSoundType(state, world, pos, entity);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        return this.getBlockEntityOptional((BlockGetter)pLevel, pPos).map(vte -> vte.getCapability(ForgeCapabilities.ITEM_HANDLER)).map(lo -> lo.map(ItemHelper::calcRedstoneFromInventory).orElse(0)).orElse(0);
    }

    public abstract BlockEntityType<BE> getBlockEntityType();

    public abstract Class<BE> getBlockEntityClass();
}

