/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block.entity;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryWrapper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.zlt.create_vibrant_vaults.block.AbstractItemVaultBlock;

public abstract class AbstractItemVaultBlockEntity<BE extends AbstractItemVaultBlockEntity<BE>>
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Inventory {
    protected LazyOptional<IItemHandler> itemCapability;
    public ItemStackHandler inventory;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity;
    public int radius;
    public int length;
    protected Direction.Axis axis;

    public AbstractItemVaultBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new ItemStackHandler((Integer)AllConfigs.server().logistics.vaultCapacity.get()){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                AbstractItemVaultBlockEntity.this.updateComparators();
            }
        };
        this.itemCapability = LazyOptional.empty();
        this.radius = 1;
        this.length = 1;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && this.isController()) {
            ConnectivityHandler.formMulti((BlockEntity)this);
        }
    }

    protected void updateComparators() {
        if (this.f_58857_ == null) {
            return;
        }
        BE controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        this.f_58857_.m_151543_(((AbstractItemVaultBlockEntity)((Object)controllerBE)).f_58858_);
        BlockPos pos = controllerBE.m_58899_();
        for (int y = 0; y < ((AbstractItemVaultBlockEntity)((Object)controllerBE)).radius; ++y) {
            for (int z = 0; z < (((AbstractItemVaultBlockEntity)((Object)controllerBE)).axis == Direction.Axis.X ? ((AbstractItemVaultBlockEntity)((Object)controllerBE)).radius : ((AbstractItemVaultBlockEntity)((Object)controllerBE)).length); ++z) {
                for (int x = 0; x < (((AbstractItemVaultBlockEntity)((Object)controllerBE)).axis == Direction.Axis.Z ? ((AbstractItemVaultBlockEntity)((Object)controllerBE)).radius : ((AbstractItemVaultBlockEntity)((Object)controllerBE)).length); ++x) {
                    this.f_58857_.m_46717_(pos.m_7918_(x, y, z), this.m_58900_().m_60734_());
                }
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_)) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    protected abstract BE getAsBE(BlockEntity var1);

    public BE getControllerBE() {
        if (this.isController()) {
            return (BE)((Object)this);
        }
        if (this.f_58857_ == null) {
            return null;
        }
        return this.getAsBE(this.f_58857_.m_7702_(this.controller));
    }

    protected abstract boolean isVault(BlockState var1);

    public void removeController(boolean keepContents) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.radius = 1;
        this.length = 1;
        BlockState state = this.m_58900_();
        if (this.isVault(state)) {
            state = (BlockState)state.m_61124_((Property)AbstractItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(false));
            this.f_58857_.m_7731_(this.f_58858_, state, 22);
        }
        this.itemCapability.invalidate();
        this.m_6596_();
        this.sendData();
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.itemCapability.invalidate();
        this.m_6596_();
        this.sendData();
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevLength = this.length;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.radius = compound.m_128451_("Size");
            this.length = compound.m_128451_("Length");
        }
        if (!clientPacket) {
            this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
            return;
        }
        if (!(this.f_58857_ == null || Objects.equals(controllerBefore, this.controller) && prevSize == this.radius && prevLength == this.length)) {
            this.f_58857_.m_6550_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_());
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128405_("Size", this.radius);
            compound.m_128405_("Length", this.length);
        }
        super.write(compound, clientPacket);
        if (!clientPacket) {
            compound.m_128359_("StorageType", "CombinedInv");
            compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        }
    }

    public ItemStackHandler getInventoryOfBlock() {
        return this.inventory;
    }

    public void applyInventoryToBlock(ItemStackHandler handler) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, i < handler.getSlots() ? handler.getStackInSlot(i) : ItemStack.f_41583_);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            this.initCapability();
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    protected abstract Direction.Axis getVaultBlockAxis(BlockState var1);

    protected abstract BlockEntityType<BE> getBlockEntityType();

    protected void initCapability() {
        if (this.itemCapability.isPresent()) {
            return;
        }
        if (!this.isController()) {
            BE controllerBE = this.getControllerBE();
            if (controllerBE != null) {
                ((AbstractItemVaultBlockEntity)((Object)controllerBE)).initCapability();
                this.itemCapability = ((AbstractItemVaultBlockEntity)((Object)controllerBE)).itemCapability;
            }
            return;
        }
        if (this.f_58857_ == null) {
            return;
        }
        boolean alongZ = this.getVaultBlockAxis(this.m_58900_()) == Direction.Axis.Z;
        IItemHandlerModifiable[] invs = new IItemHandlerModifiable[this.length * this.radius * this.radius];
        for (int yOffset = 0; yOffset < this.length; ++yOffset) {
            for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
                for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                    AbstractItemVaultBlockEntity vaultAt = (AbstractItemVaultBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (BlockGetter)this.f_58857_, (BlockPos)(alongZ ? this.f_58858_.m_7918_(xOffset, zOffset, yOffset) : this.f_58858_.m_7918_(yOffset, xOffset, zOffset)));
                    invs[yOffset * this.radius * this.radius + xOffset * this.radius + zOffset] = vaultAt != null ? vaultAt.inventory : new ItemStackHandler();
                }
            }
        }
        VersionedInventoryWrapper itemHandler = new VersionedInventoryWrapper((IItemHandlerModifiable)new CombinedInvWrapper(invs));
        this.itemCapability = LazyOptional.of(() -> AbstractItemVaultBlockEntity.lambda$initCapability$0((IItemHandler)itemHandler));
    }

    public static int getMaxLength(int radius) {
        return radius * 3;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (this.f_58857_ != null && this.isVault(state)) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)AbstractItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(this.radius > 2)), 6);
        }
        this.itemCapability.invalidate();
        this.m_6596_();
    }

    public Direction.Axis getMainConnectionAxis() {
        return this.getMainAxisOf((BlockEntity)this);
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        return longAxis == Direction.Axis.Y ? this.getMaxWidth() : AbstractItemVaultBlockEntity.getMaxLength(width);
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.length;
    }

    public int getWidth() {
        return this.radius;
    }

    public void setHeight(int height) {
        this.length = height;
    }

    public void setWidth(int width) {
        this.radius = width;
    }

    public boolean hasInventory() {
        return true;
    }

    private static /* synthetic */ IItemHandler lambda$initCapability$0(IItemHandler itemHandler) {
        return itemHandler;
    }
}

