/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block.item_vault;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.zlt.create_vibrant_vaults.block.AbstractItemVaultBlock;
import net.zlt.create_vibrant_vaults.block.AllBlocks;
import net.zlt.create_vibrant_vaults.block.entity.AllBlockEntityTypes;
import net.zlt.create_vibrant_vaults.block.entity.item_vault.GreenItemVaultBlockEntity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GreenItemVaultBlock
extends AbstractItemVaultBlock<GreenItemVaultBlockEntity> {
    public GreenItemVaultBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected GreenItemVaultBlockEntity getAsBE(BlockEntity blockEntity) {
        return blockEntity instanceof GreenItemVaultBlockEntity ? (GreenItemVaultBlockEntity)blockEntity : null;
    }

    public static boolean sIsVault(BlockState state) {
        return AllBlocks.GREEN_ITEM_VAULT.has(state);
    }

    @Nullable
    public static Direction.Axis sGetVaultBlockAxis(BlockState state) {
        return !GreenItemVaultBlock.sIsVault(state) ? null : (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
    }

    public static boolean sIsLarge(BlockState state) {
        return GreenItemVaultBlock.sIsVault(state) && (Boolean)state.m_61143_((Property)LARGE) != false;
    }

    public static BlockEntityType<GreenItemVaultBlockEntity> sGetBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.GREEN_ITEM_VAULT.get();
    }

    @Override
    public boolean isVault(BlockState state) {
        return GreenItemVaultBlock.sIsVault(state);
    }

    @Override
    public BlockEntityType<GreenItemVaultBlockEntity> getBlockEntityType() {
        return GreenItemVaultBlock.sGetBlockEntityType();
    }

    @Override
    public Class<GreenItemVaultBlockEntity> getBlockEntityClass() {
        return GreenItemVaultBlockEntity.class;
    }

    @Override
    @Nullable
    public Block getVerticalVaultBlock() {
        return (Block)AllBlocks.GREEN_VERTICAL_ITEM_VAULT.get();
    }
}

