/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block.item_vault;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.zlt.create_vibrant_vaults.block.AbstractItemVaultBlock;
import net.zlt.create_vibrant_vaults.block.AllBlocks;
import net.zlt.create_vibrant_vaults.block.entity.AllBlockEntityTypes;
import net.zlt.create_vibrant_vaults.block.entity.item_vault.MagentaItemVaultBlockEntity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MagentaItemVaultBlock
extends AbstractItemVaultBlock<MagentaItemVaultBlockEntity> {
    public MagentaItemVaultBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    protected MagentaItemVaultBlockEntity getAsBE(BlockEntity blockEntity) {
        return blockEntity instanceof MagentaItemVaultBlockEntity ? (MagentaItemVaultBlockEntity)blockEntity : null;
    }

    public static boolean sIsVault(BlockState state) {
        return AllBlocks.MAGENTA_ITEM_VAULT.has(state);
    }

    @Nullable
    public static Direction.Axis sGetVaultBlockAxis(BlockState state) {
        return !MagentaItemVaultBlock.sIsVault(state) ? null : (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
    }

    public static boolean sIsLarge(BlockState state) {
        return MagentaItemVaultBlock.sIsVault(state) && (Boolean)state.m_61143_((Property)LARGE) != false;
    }

    public static BlockEntityType<MagentaItemVaultBlockEntity> sGetBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.MAGENTA_ITEM_VAULT.get();
    }

    @Override
    public boolean isVault(BlockState state) {
        return MagentaItemVaultBlock.sIsVault(state);
    }

    @Override
    public BlockEntityType<MagentaItemVaultBlockEntity> getBlockEntityType() {
        return MagentaItemVaultBlock.sGetBlockEntityType();
    }

    @Override
    public Class<MagentaItemVaultBlockEntity> getBlockEntityClass() {
        return MagentaItemVaultBlockEntity.class;
    }

    @Override
    @Nullable
    public Block getVerticalVaultBlock() {
        return (Block)AllBlocks.MAGENTA_VERTICAL_ITEM_VAULT.get();
    }
}

