/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block.item_vault;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.zlt.create_vibrant_vaults.block.AbstractItemVaultBlock;
import net.zlt.create_vibrant_vaults.block.AllBlocks;
import net.zlt.create_vibrant_vaults.block.entity.AllBlockEntityTypes;
import net.zlt.create_vibrant_vaults.block.entity.item_vault.RedItemVaultBlockEntity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RedItemVaultBlock
extends AbstractItemVaultBlock<RedItemVaultBlockEntity> {
    public RedItemVaultBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected RedItemVaultBlockEntity getAsBE(BlockEntity blockEntity) {
        return blockEntity instanceof RedItemVaultBlockEntity ? (RedItemVaultBlockEntity)blockEntity : null;
    }

    public static boolean sIsVault(BlockState state) {
        return AllBlocks.RED_ITEM_VAULT.has(state);
    }

    @Nullable
    public static Direction.Axis sGetVaultBlockAxis(BlockState state) {
        return !RedItemVaultBlock.sIsVault(state) ? null : (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
    }

    public static boolean sIsLarge(BlockState state) {
        return RedItemVaultBlock.sIsVault(state) && (Boolean)state.m_61143_((Property)LARGE) != false;
    }

    public static BlockEntityType<RedItemVaultBlockEntity> sGetBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.RED_ITEM_VAULT.get();
    }

    @Override
    public boolean isVault(BlockState state) {
        return RedItemVaultBlock.sIsVault(state);
    }

    @Override
    public BlockEntityType<RedItemVaultBlockEntity> getBlockEntityType() {
        return RedItemVaultBlock.sGetBlockEntityType();
    }

    @Override
    public Class<RedItemVaultBlockEntity> getBlockEntityClass() {
        return RedItemVaultBlockEntity.class;
    }

    @Override
    @Nullable
    public Block getVerticalVaultBlock() {
        return (Block)AllBlocks.RED_VERTICAL_ITEM_VAULT.get();
    }
}

