/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block.item_vault.vertical;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.zlt.create_vibrant_vaults.block.AbstractVerticalItemVaultBlock;
import net.zlt.create_vibrant_vaults.block.AllBlocks;
import net.zlt.create_vibrant_vaults.block.entity.AllBlockEntityTypes;
import net.zlt.create_vibrant_vaults.block.entity.item_vault.vertical.LightGrayVerticalItemVaultBlockEntity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LightGrayVerticalItemVaultBlock
extends AbstractVerticalItemVaultBlock<LightGrayVerticalItemVaultBlockEntity> {
    public LightGrayVerticalItemVaultBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected LightGrayVerticalItemVaultBlockEntity getAsBE(BlockEntity blockEntity) {
        return blockEntity instanceof LightGrayVerticalItemVaultBlockEntity ? (LightGrayVerticalItemVaultBlockEntity)blockEntity : null;
    }

    public static boolean sIsVault(BlockState state) {
        return AllBlocks.LIGHT_GRAY_VERTICAL_ITEM_VAULT.has(state);
    }

    @Nullable
    public static Direction.Axis sGetVaultBlockAxis(BlockState state) {
        return !LightGrayVerticalItemVaultBlock.sIsVault(state) ? null : Direction.Axis.Y;
    }

    public static boolean sIsLarge(BlockState state) {
        return LightGrayVerticalItemVaultBlock.sIsVault(state) && (Boolean)state.m_61143_((Property)LARGE) != false;
    }

    public static BlockEntityType<LightGrayVerticalItemVaultBlockEntity> sGetBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.LIGHT_GRAY_VERTICAL_ITEM_VAULT.get();
    }

    @Override
    public boolean isVault(BlockState state) {
        return LightGrayVerticalItemVaultBlock.sIsVault(state);
    }

    @Override
    public BlockEntityType<LightGrayVerticalItemVaultBlockEntity> getBlockEntityType() {
        return LightGrayVerticalItemVaultBlock.sGetBlockEntityType();
    }

    @Override
    public Class<LightGrayVerticalItemVaultBlockEntity> getBlockEntityClass() {
        return LightGrayVerticalItemVaultBlockEntity.class;
    }

    @Override
    @Nullable
    public Block getHorizontalVaultBlock() {
        return (Block)AllBlocks.LIGHT_GRAY_ITEM_VAULT.get();
    }
}

