/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block.item_vault.vertical;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.zlt.create_vibrant_vaults.block.AbstractVerticalItemVaultBlock;
import net.zlt.create_vibrant_vaults.block.AllBlocks;
import net.zlt.create_vibrant_vaults.block.entity.AllBlockEntityTypes;
import net.zlt.create_vibrant_vaults.block.entity.item_vault.vertical.LimeVerticalItemVaultBlockEntity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LimeVerticalItemVaultBlock
extends AbstractVerticalItemVaultBlock<LimeVerticalItemVaultBlockEntity> {
    public LimeVerticalItemVaultBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected LimeVerticalItemVaultBlockEntity getAsBE(BlockEntity blockEntity) {
        return blockEntity instanceof LimeVerticalItemVaultBlockEntity ? (LimeVerticalItemVaultBlockEntity)blockEntity : null;
    }

    public static boolean sIsVault(BlockState state) {
        return AllBlocks.LIME_VERTICAL_ITEM_VAULT.has(state);
    }

    @Nullable
    public static Direction.Axis sGetVaultBlockAxis(BlockState state) {
        return !LimeVerticalItemVaultBlock.sIsVault(state) ? null : Direction.Axis.Y;
    }

    public static boolean sIsLarge(BlockState state) {
        return LimeVerticalItemVaultBlock.sIsVault(state) && (Boolean)state.m_61143_((Property)LARGE) != false;
    }

    public static BlockEntityType<LimeVerticalItemVaultBlockEntity> sGetBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.LIME_VERTICAL_ITEM_VAULT.get();
    }

    @Override
    public boolean isVault(BlockState state) {
        return LimeVerticalItemVaultBlock.sIsVault(state);
    }

    @Override
    public BlockEntityType<LimeVerticalItemVaultBlockEntity> getBlockEntityType() {
        return LimeVerticalItemVaultBlock.sGetBlockEntityType();
    }

    @Override
    public Class<LimeVerticalItemVaultBlockEntity> getBlockEntityClass() {
        return LimeVerticalItemVaultBlockEntity.class;
    }

    @Override
    @Nullable
    public Block getHorizontalVaultBlock() {
        return (Block)AllBlocks.LIME_ITEM_VAULT.get();
    }
}

