/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block.item_vault.vertical;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.zlt.create_vibrant_vaults.block.AbstractVerticalItemVaultBlock;
import net.zlt.create_vibrant_vaults.block.AllBlocks;
import net.zlt.create_vibrant_vaults.block.entity.AllBlockEntityTypes;
import net.zlt.create_vibrant_vaults.block.entity.item_vault.vertical.VerticalItemVaultBlockEntity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class VerticalItemVaultBlock
extends AbstractVerticalItemVaultBlock<VerticalItemVaultBlockEntity> {
    public VerticalItemVaultBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected VerticalItemVaultBlockEntity getAsBE(BlockEntity blockEntity) {
        return blockEntity instanceof VerticalItemVaultBlockEntity ? (VerticalItemVaultBlockEntity)blockEntity : null;
    }

    public static boolean sIsVault(BlockState state) {
        return AllBlocks.VERTICAL_ITEM_VAULT.has(state);
    }

    @Nullable
    public static Direction.Axis sGetVaultBlockAxis(BlockState state) {
        return !VerticalItemVaultBlock.sIsVault(state) ? null : Direction.Axis.Y;
    }

    public static boolean sIsLarge(BlockState state) {
        return VerticalItemVaultBlock.sIsVault(state) && (Boolean)state.m_61143_((Property)LARGE) != false;
    }

    public static BlockEntityType<VerticalItemVaultBlockEntity> sGetBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.VERTICAL_ITEM_VAULT.get();
    }

    @Override
    public boolean isVault(BlockState state) {
        return VerticalItemVaultBlock.sIsVault(state);
    }

    @Override
    public BlockEntityType<VerticalItemVaultBlockEntity> getBlockEntityType() {
        return VerticalItemVaultBlock.sGetBlockEntityType();
    }

    @Override
    public Class<VerticalItemVaultBlockEntity> getBlockEntityClass() {
        return VerticalItemVaultBlockEntity.class;
    }

    @Override
    @Nullable
    public Block getHorizontalVaultBlock() {
        return (Block)com.simibubi.create.AllBlocks.ITEM_VAULT.get();
    }
}

