/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block.shipping_container;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.zlt.create_vibrant_vaults.block.AbstractItemVaultBlock;
import net.zlt.create_vibrant_vaults.block.AllBlocks;
import net.zlt.create_vibrant_vaults.block.entity.AllBlockEntityTypes;
import net.zlt.create_vibrant_vaults.block.entity.shipping_container.GreenShippingContainerBlockEntity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GreenShippingContainerBlock
extends AbstractItemVaultBlock<GreenShippingContainerBlockEntity> {
    public GreenShippingContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected GreenShippingContainerBlockEntity getAsBE(BlockEntity blockEntity) {
        return blockEntity instanceof GreenShippingContainerBlockEntity ? (GreenShippingContainerBlockEntity)blockEntity : null;
    }

    public static boolean sIsVault(BlockState state) {
        return AllBlocks.GREEN_SHIPPING_CONTAINER.has(state);
    }

    @Nullable
    public static Direction.Axis sGetVaultBlockAxis(BlockState state) {
        return !GreenShippingContainerBlock.sIsVault(state) ? null : (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
    }

    public static boolean sIsLarge(BlockState state) {
        return GreenShippingContainerBlock.sIsVault(state) && (Boolean)state.m_61143_((Property)LARGE) != false;
    }

    public static BlockEntityType<GreenShippingContainerBlockEntity> sGetBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.GREEN_SHIPPING_CONTAINER.get();
    }

    @Override
    public boolean isVault(BlockState state) {
        return GreenShippingContainerBlock.sIsVault(state);
    }

    @Override
    public BlockEntityType<GreenShippingContainerBlockEntity> getBlockEntityType() {
        return GreenShippingContainerBlock.sGetBlockEntityType();
    }

    @Override
    public Class<GreenShippingContainerBlockEntity> getBlockEntityClass() {
        return GreenShippingContainerBlockEntity.class;
    }

    @Override
    @Nullable
    public Block getVerticalVaultBlock() {
        return (Block)AllBlocks.GREEN_VERTICAL_SHIPPING_CONTAINER.get();
    }
}

