/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block.shipping_container;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.zlt.create_vibrant_vaults.block.AbstractItemVaultBlock;
import net.zlt.create_vibrant_vaults.block.AllBlocks;
import net.zlt.create_vibrant_vaults.block.entity.AllBlockEntityTypes;
import net.zlt.create_vibrant_vaults.block.entity.shipping_container.LightGrayShippingContainerBlockEntity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LightGrayShippingContainerBlock
extends AbstractItemVaultBlock<LightGrayShippingContainerBlockEntity> {
    public LightGrayShippingContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected LightGrayShippingContainerBlockEntity getAsBE(BlockEntity blockEntity) {
        return blockEntity instanceof LightGrayShippingContainerBlockEntity ? (LightGrayShippingContainerBlockEntity)blockEntity : null;
    }

    public static boolean sIsVault(BlockState state) {
        return AllBlocks.LIGHT_GRAY_SHIPPING_CONTAINER.has(state);
    }

    @Nullable
    public static Direction.Axis sGetVaultBlockAxis(BlockState state) {
        return !LightGrayShippingContainerBlock.sIsVault(state) ? null : (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
    }

    public static boolean sIsLarge(BlockState state) {
        return LightGrayShippingContainerBlock.sIsVault(state) && (Boolean)state.m_61143_((Property)LARGE) != false;
    }

    public static BlockEntityType<LightGrayShippingContainerBlockEntity> sGetBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.LIGHT_GRAY_SHIPPING_CONTAINER.get();
    }

    @Override
    public boolean isVault(BlockState state) {
        return LightGrayShippingContainerBlock.sIsVault(state);
    }

    @Override
    public BlockEntityType<LightGrayShippingContainerBlockEntity> getBlockEntityType() {
        return LightGrayShippingContainerBlock.sGetBlockEntityType();
    }

    @Override
    public Class<LightGrayShippingContainerBlockEntity> getBlockEntityClass() {
        return LightGrayShippingContainerBlockEntity.class;
    }

    @Override
    @Nullable
    public Block getVerticalVaultBlock() {
        return (Block)AllBlocks.LIGHT_GRAY_VERTICAL_SHIPPING_CONTAINER.get();
    }
}

