/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block.shipping_container;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.zlt.create_vibrant_vaults.block.AbstractItemVaultBlock;
import net.zlt.create_vibrant_vaults.block.AllBlocks;
import net.zlt.create_vibrant_vaults.block.entity.AllBlockEntityTypes;
import net.zlt.create_vibrant_vaults.block.entity.shipping_container.MagentaShippingContainerBlockEntity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MagentaShippingContainerBlock
extends AbstractItemVaultBlock<MagentaShippingContainerBlockEntity> {
    public MagentaShippingContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected MagentaShippingContainerBlockEntity getAsBE(BlockEntity blockEntity) {
        return blockEntity instanceof MagentaShippingContainerBlockEntity ? (MagentaShippingContainerBlockEntity)blockEntity : null;
    }

    public static boolean sIsVault(BlockState state) {
        return AllBlocks.MAGENTA_SHIPPING_CONTAINER.has(state);
    }

    @Nullable
    public static Direction.Axis sGetVaultBlockAxis(BlockState state) {
        return !MagentaShippingContainerBlock.sIsVault(state) ? null : (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
    }

    public static boolean sIsLarge(BlockState state) {
        return MagentaShippingContainerBlock.sIsVault(state) && (Boolean)state.m_61143_((Property)LARGE) != false;
    }

    public static BlockEntityType<MagentaShippingContainerBlockEntity> sGetBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.MAGENTA_SHIPPING_CONTAINER.get();
    }

    @Override
    public boolean isVault(BlockState state) {
        return MagentaShippingContainerBlock.sIsVault(state);
    }

    @Override
    public BlockEntityType<MagentaShippingContainerBlockEntity> getBlockEntityType() {
        return MagentaShippingContainerBlock.sGetBlockEntityType();
    }

    @Override
    public Class<MagentaShippingContainerBlockEntity> getBlockEntityClass() {
        return MagentaShippingContainerBlockEntity.class;
    }

    @Override
    @Nullable
    public Block getVerticalVaultBlock() {
        return (Block)AllBlocks.MAGENTA_VERTICAL_SHIPPING_CONTAINER.get();
    }
}

