/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block.shipping_container;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.zlt.create_vibrant_vaults.block.AbstractItemVaultBlock;
import net.zlt.create_vibrant_vaults.block.AllBlocks;
import net.zlt.create_vibrant_vaults.block.entity.AllBlockEntityTypes;
import net.zlt.create_vibrant_vaults.block.entity.shipping_container.WhiteShippingContainerBlockEntity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WhiteShippingContainerBlock
extends AbstractItemVaultBlock<WhiteShippingContainerBlockEntity> {
    public WhiteShippingContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected WhiteShippingContainerBlockEntity getAsBE(BlockEntity blockEntity) {
        return blockEntity instanceof WhiteShippingContainerBlockEntity ? (WhiteShippingContainerBlockEntity)blockEntity : null;
    }

    public static boolean sIsVault(BlockState state) {
        return AllBlocks.WHITE_SHIPPING_CONTAINER.has(state);
    }

    @Nullable
    public static Direction.Axis sGetVaultBlockAxis(BlockState state) {
        return !WhiteShippingContainerBlock.sIsVault(state) ? null : (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
    }

    public static boolean sIsLarge(BlockState state) {
        return WhiteShippingContainerBlock.sIsVault(state) && (Boolean)state.m_61143_((Property)LARGE) != false;
    }

    public static BlockEntityType<WhiteShippingContainerBlockEntity> sGetBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.WHITE_SHIPPING_CONTAINER.get();
    }

    @Override
    public boolean isVault(BlockState state) {
        return WhiteShippingContainerBlock.sIsVault(state);
    }

    @Override
    public BlockEntityType<WhiteShippingContainerBlockEntity> getBlockEntityType() {
        return WhiteShippingContainerBlock.sGetBlockEntityType();
    }

    @Override
    public Class<WhiteShippingContainerBlockEntity> getBlockEntityClass() {
        return WhiteShippingContainerBlockEntity.class;
    }

    @Override
    @Nullable
    public Block getVerticalVaultBlock() {
        return (Block)AllBlocks.WHITE_VERTICAL_SHIPPING_CONTAINER.get();
    }
}

