/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block.shipping_container.vertical;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.zlt.create_vibrant_vaults.block.AbstractVerticalItemVaultBlock;
import net.zlt.create_vibrant_vaults.block.AllBlocks;
import net.zlt.create_vibrant_vaults.block.entity.AllBlockEntityTypes;
import net.zlt.create_vibrant_vaults.block.entity.shipping_container.vertical.GreenVerticalShippingContainerBlockEntity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GreenVerticalShippingContainerBlock
extends AbstractVerticalItemVaultBlock<GreenVerticalShippingContainerBlockEntity> {
    public GreenVerticalShippingContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected GreenVerticalShippingContainerBlockEntity getAsBE(BlockEntity blockEntity) {
        return blockEntity instanceof GreenVerticalShippingContainerBlockEntity ? (GreenVerticalShippingContainerBlockEntity)blockEntity : null;
    }

    public static boolean sIsVault(BlockState state) {
        return AllBlocks.GREEN_VERTICAL_SHIPPING_CONTAINER.has(state);
    }

    @Nullable
    public static Direction.Axis sGetVaultBlockAxis(BlockState state) {
        return !GreenVerticalShippingContainerBlock.sIsVault(state) ? null : Direction.Axis.Y;
    }

    public static boolean sIsLarge(BlockState state) {
        return GreenVerticalShippingContainerBlock.sIsVault(state) && (Boolean)state.m_61143_((Property)LARGE) != false;
    }

    public static BlockEntityType<GreenVerticalShippingContainerBlockEntity> sGetBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.GREEN_VERTICAL_SHIPPING_CONTAINER.get();
    }

    @Override
    public boolean isVault(BlockState state) {
        return GreenVerticalShippingContainerBlock.sIsVault(state);
    }

    @Override
    public BlockEntityType<GreenVerticalShippingContainerBlockEntity> getBlockEntityType() {
        return GreenVerticalShippingContainerBlock.sGetBlockEntityType();
    }

    @Override
    public Class<GreenVerticalShippingContainerBlockEntity> getBlockEntityClass() {
        return GreenVerticalShippingContainerBlockEntity.class;
    }

    @Override
    @Nullable
    public Block getHorizontalVaultBlock() {
        return (Block)AllBlocks.GREEN_SHIPPING_CONTAINER.get();
    }
}

