/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.item;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.zlt.create_vibrant_vaults.block.entity.AbstractItemVaultBlockEntity;

public abstract class AbstractItemVaultItem<BE extends AbstractItemVaultBlockEntity<BE>>
extends BlockItem {
    public AbstractItemVaultItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public InteractionResult m_40576_(BlockPlaceContext ctx) {
        InteractionResult initialResult = super.m_40576_(ctx);
        if (initialResult.m_19077_()) {
            this.tryMultiPlace(ctx);
        }
        return initialResult;
    }

    protected boolean m_7274_(BlockPos pos, Level level, @Nullable Player player, ItemStack itemStack, BlockState state) {
        MinecraftServer minecraftserver = level.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag nbt = itemStack.m_41737_("BlockEntityTag");
        if (nbt != null) {
            nbt.m_128473_("Length");
            nbt.m_128473_("Size");
            nbt.m_128473_("Controller");
            nbt.m_128473_("LastKnownPos");
        }
        return super.m_7274_(pos, level, player, itemStack, state);
    }

    protected abstract boolean isVault(BlockState var1);

    protected abstract BlockEntityType<BE> getBlockEntityType();

    @Nullable
    protected abstract Direction.Axis getVaultBlockAxis(BlockState var1);

    protected void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState blockState;
        BlockPos offsetPos;
        int zOffset;
        int xOffset;
        BlockPos startPos;
        BlockPos pos;
        BlockPos placedOnPos;
        Player player = ctx.m_43723_();
        if (player == null || player.m_6144_()) {
            return;
        }
        Direction face = ctx.m_43719_();
        ItemStack stack = ctx.m_43722_();
        Level world = ctx.m_43725_();
        BlockState placedOnState = world.m_8055_(placedOnPos = (pos = ctx.m_8083_()).m_121945_(face.m_122424_()));
        if (!this.isVault(placedOnState)) {
            return;
        }
        AbstractItemVaultBlockEntity vaultAt = (AbstractItemVaultBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (BlockGetter)world, (BlockPos)placedOnPos);
        if (vaultAt == null) {
            return;
        }
        Object controllerBE = vaultAt.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        int width = ((AbstractItemVaultBlockEntity)((Object)controllerBE)).radius;
        if (width == 1) {
            return;
        }
        int vaultsToPlace = 0;
        Direction.Axis vaultBlockAxis = this.getVaultBlockAxis(placedOnState);
        if (vaultBlockAxis == null || face.m_122434_() != vaultBlockAxis) {
            return;
        }
        Direction vaultFacing = Direction.m_122387_((Direction.Axis)vaultBlockAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        BlockPos blockPos = startPos = face == vaultFacing.m_122424_() ? controllerBE.m_58899_().m_121945_(vaultFacing.m_122424_()) : controllerBE.m_58899_().m_5484_(vaultFacing, ((AbstractItemVaultBlockEntity)((Object)controllerBE)).length);
        if (VecHelper.getCoordinate((Vec3i)startPos, (Direction.Axis)vaultBlockAxis) != VecHelper.getCoordinate((Vec3i)pos, (Direction.Axis)vaultBlockAxis)) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = vaultBlockAxis == Direction.Axis.X ? startPos.m_7918_(0, xOffset, zOffset) : startPos.m_7918_(xOffset, zOffset, 0);
                blockState = world.m_8055_(offsetPos);
                if (this.isVault(blockState)) continue;
                if (!blockState.m_247087_()) {
                    return;
                }
                ++vaultsToPlace;
            }
        }
        if (!player.m_7500_() && stack.m_41613_() < vaultsToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = vaultBlockAxis == Direction.Axis.X ? startPos.m_7918_(0, xOffset, zOffset) : startPos.m_7918_(xOffset, zOffset, 0);
                blockState = world.m_8055_(offsetPos);
                if (this.isVault(blockState)) continue;
                BlockPlaceContext context = BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)offsetPos, (Direction)face);
                player.getPersistentData().m_128379_("SilenceVaultSound", true);
                super.m_40576_(context);
                player.getPersistentData().m_128473_("SilenceVaultSound");
            }
        }
    }
}

