/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.loot.condition;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.condition.LootConditions")
@Document(value="vanilla/api/loot/condition/LootConditions")
public class LootConditions {
    private final Predicate<LootContext> gather;

    private LootConditions(Predicate<LootContext> gather) {
        this.gather = gather;
    }

    @ZenCodeType.Method
    public static LootConditions none() {
        return new LootConditions(it -> true);
    }

    @ZenCodeType.Method
    public static LootConditions randomlyIn(double percentageChance) {
        return new LootConditions(it -> it.m_230907_().m_188500_() <= percentageChance);
    }

    @ZenCodeType.Method
    public static LootConditions only(LootItemCondition condition) {
        return new LootConditions((Predicate<LootContext>)condition);
    }

    @ZenCodeType.Method
    public static LootConditions only(LootItemCondition.Builder builder) {
        return LootConditions.only(builder.m_6409_());
    }

    @ZenCodeType.Method
    public static LootConditions allOf(LootItemCondition ... conditions) {
        return new LootConditions(LootItemConditions.m_81834_((Predicate[])conditions));
    }

    @ZenCodeType.Method
    public static LootConditions allOf(LootItemCondition.Builder ... builders) {
        return LootConditions.allOf((LootItemCondition[])Arrays.stream(builders).map(LootItemCondition.Builder::m_6409_).toArray(LootItemCondition[]::new));
    }

    @ZenCodeType.Method
    public static LootConditions anyOf(LootItemCondition ... conditions) {
        return new LootConditions(LootItemConditions.m_81841_((Predicate[])conditions));
    }

    @ZenCodeType.Method
    public static LootConditions anyOf(LootItemCondition.Builder ... builders) {
        return LootConditions.anyOf((LootItemCondition[])Arrays.stream(builders).map(LootItemCondition.Builder::m_6409_).toArray(LootItemCondition[]::new));
    }

    @ZenCodeType.Method
    public static LootConditions noneOf(LootItemCondition ... conditions) {
        return LootConditions.allOf(conditions).flip();
    }

    @ZenCodeType.Method
    public static LootConditions noneOf(LootItemCondition.Builder ... builders) {
        return LootConditions.noneOf((LootItemCondition[])Arrays.stream(builders).map(LootItemCondition.Builder::m_6409_).toArray(LootItemCondition[]::new));
    }

    @ZenCodeType.Method
    public static LootConditions notAllOf(LootItemCondition ... conditions) {
        return LootConditions.anyOf(conditions).flip();
    }

    @ZenCodeType.Method
    public static LootConditions notAllOf(LootItemCondition.Builder ... builders) {
        return LootConditions.notAllOf((LootItemCondition[])Arrays.stream(builders).map(LootItemCondition.Builder::m_6409_).toArray(LootItemCondition[]::new));
    }

    public Predicate<LootContext> gather() {
        return this.gather;
    }

    private LootConditions flip() {
        return new LootConditions(this.gather.negate());
    }
}

