/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.items.AEBaseItem;
import appeng.spatial.SpatialStorageHelper;
import appeng.spatial.SpatialStoragePlot;
import appeng.spatial.SpatialStoragePlotManager;
import appeng.spatial.TransitionInfo;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpatialStorageCellItem
extends AEBaseItem
implements ISpatialStorageCell {
    private static final String TAG_PLOT_ID = "plot_id";
    private static final String TAG_PLOT_SIZE = "plot_size";
    private final int maxRegion;

    public SpatialStorageCellItem(Item.Properties props, int spatialScale) {
        super(props);
        this.maxRegion = spatialScale;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        int plotId = this.getAllocatedPlotId(stack);
        if (plotId == -1) {
            lines.add((Component)Tooltips.of(GuiText.Unformatted, new Object[0]).m_130940_(ChatFormatting.ITALIC));
            lines.add((Component)Tooltips.of(GuiText.SpatialCapacity, this.maxRegion, this.maxRegion, this.maxRegion));
            return;
        }
        String serialNumber = String.format(Locale.ROOT, "SP-%04d", plotId);
        lines.add((Component)Tooltips.of(GuiText.SerialNumber, serialNumber));
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(TAG_PLOT_SIZE, 4)) {
            BlockPos size = BlockPos.m_122022_((long)tag.m_128454_(TAG_PLOT_SIZE));
            lines.add((Component)Tooltips.of(GuiText.StoredSize, size.m_123341_(), size.m_123342_(), size.m_123343_()));
        }
    }

    @Override
    public boolean isSpatialStorage(ItemStack is) {
        return true;
    }

    @Override
    public int getMaxStoredDim(ItemStack is) {
        return this.maxRegion;
    }

    @Override
    public int getAllocatedPlotId(ItemStack is) {
        CompoundTag c = is.m_41783_();
        if (c != null && c.m_128441_(TAG_PLOT_ID)) {
            try {
                int plotId = c.m_128451_(TAG_PLOT_ID);
                if (SpatialStoragePlotManager.INSTANCE.getPlot(plotId) == null) {
                    return -1;
                }
                return plotId;
            }
            catch (Exception e) {
                AELog.warn("Failed to retrieve spatial storage dimension: %s", e);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doSpatialTransition(ItemStack is, ServerLevel level, BlockPos min, BlockPos max, int playerId) {
        int targetX = max.m_123341_() - min.m_123341_() - 1;
        int targetY = max.m_123342_() - min.m_123342_() - 1;
        int targetZ = max.m_123343_() - min.m_123343_() - 1;
        int maxSize = this.getMaxStoredDim(is);
        if (targetX > maxSize || targetY > maxSize || targetZ > maxSize) {
            AELog.info("Failing spatial transition because the transfer area (%dx%dx%d) exceeds the cell capacity (%s).", targetX, targetY, targetZ, maxSize);
            return false;
        }
        BlockPos targetSize = new BlockPos(targetX, targetY, targetZ);
        SpatialStoragePlotManager manager = SpatialStoragePlotManager.INSTANCE;
        SpatialStoragePlot plot = SpatialStoragePlotManager.INSTANCE.getPlot(this.getAllocatedPlotId(is));
        if (plot != null) {
            if (!plot.getSize().equals((Object)targetSize)) {
                AELog.info("Failing spatial transition because the transfer area (%dx%dx%d) does not match the spatial storage plot's size (%s).", targetX, targetY, targetZ, plot.getSize());
                return false;
            }
        } else {
            plot = manager.allocatePlot(targetSize, playerId);
        }
        TransitionInfo info = new TransitionInfo(level.m_46472_().m_135782_(), min, max, Instant.now());
        manager.setLastTransition(plot.getId(), info);
        try {
            ServerLevel cellLevel = manager.getLevel();
            BlockPos offset = plot.getOrigin();
            this.setStoredDimension(is, plot.getId(), plot.getSize());
            SpatialStorageHelper.getInstance().swapRegions(level, min.m_123341_() + 1, min.m_123342_() + 1, min.m_123343_() + 1, cellLevel, offset.m_123341_(), offset.m_123342_(), offset.m_123343_(), targetX - 1, targetY - 1, targetZ - 1);
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.getAllocatedPlotId(is) == -1) {
                manager.freePlot(plot.getId(), true);
            }
        }
    }

    public void setStoredDimension(ItemStack is, int plotId, BlockPos size) {
        CompoundTag c = is.m_41784_();
        c.m_128405_(TAG_PLOT_ID, plotId);
        c.m_128356_(TAG_PLOT_SIZE, size.m_121878_());
    }
}

