/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.engines.diesel;

import com.drmangotea.tfmg.blocks.engines.diesel.DieselEngineBlock;
import com.drmangotea.tfmg.blocks.engines.diesel.DieselEngineBlockEntity;
import com.drmangotea.tfmg.registry.TFMGPartialModels;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DieselEngineInstance
extends BlockEntityInstance<DieselEngineBlockEntity>
implements DynamicInstance {
    protected final ModelData piston;
    protected final ModelData linkage;
    protected final ModelData connector;

    public DieselEngineInstance(MaterialManager materialManager, DieselEngineBlockEntity blockEntity) {
        super(materialManager, (BlockEntity)blockEntity);
        this.piston = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(TFMGPartialModels.DIESEL_ENGINE_PISTON, this.blockState).createInstance();
        this.linkage = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(TFMGPartialModels.DIESEL_ENGINE_LINKAGE, this.blockState).createInstance();
        this.connector = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(AllPartialModels.ENGINE_CONNECTOR, this.blockState).createInstance();
    }

    public void beginFrame() {
        Float angle = ((DieselEngineBlockEntity)this.blockEntity).getTargetAngle();
        if (angle == null) {
            this.piston.setEmptyTransform();
            this.linkage.setEmptyTransform();
            this.connector.setEmptyTransform();
            return;
        }
        Direction facing = DieselEngineBlock.getFacing(this.blockState);
        Direction.Axis facingAxis = facing.m_122434_();
        Direction.Axis axis = Direction.Axis.Y;
        PoweredShaftBlockEntity shaft = ((DieselEngineBlockEntity)this.blockEntity).getShaft();
        if (shaft != null) {
            axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)shaft);
        }
        boolean roll90 = facingAxis.m_122479_() && axis == Direction.Axis.Y || facingAxis.m_122478_() && axis == Direction.Axis.Z;
        float sine = Mth.m_14031_((float)angle.floatValue());
        float sine2 = Mth.m_14031_((float)(angle.floatValue() - 1.5707964f));
        float piston = (1.0f - sine) / 4.0f * 24.0f / 16.0f;
        this.transformed(this.piston, facing, roll90).translate(0.0, (double)piston, 0.0);
        ((ModelData)((ModelData)((ModelData)this.transformed(this.linkage, facing, roll90).centre()).translate(0.0, 1.0, 0.0).unCentre()).translate(0.0, (double)piston, 0.0).translate(0.0, 0.25, 0.5).rotateX((double)(sine2 * 23.0f))).translate(0.0, -0.25, -0.5);
        ((ModelData)((ModelData)this.transformed(this.connector, facing, roll90).translate(0.0, 2.0, 0.0).centre()).rotateXRadians((double)(-angle.floatValue() + 1.5707964f))).unCentre();
    }

    protected ModelData transformed(ModelData modelData, Direction facing, boolean roll90) {
        return (ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)modelData.loadIdentity().translate((Vec3i)this.getInstancePosition())).centre()).rotateY((double)AngleHelper.horizontalAngle((Direction)facing))).rotateX((double)(AngleHelper.verticalAngle((Direction)facing) + 90.0f))).rotateY(roll90 ? -90.0 : 0.0)).unCentre();
    }

    public void updateLight() {
        BlockPos inFront = this.pos.m_6630_(10);
        this.relight(this.pos, new FlatLit[]{this.piston, this.linkage, this.connector});
    }

    protected void remove() {
        this.piston.delete();
        this.linkage.delete();
        this.connector.delete();
    }
}

