/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.engines.radial.input;

import com.drmangotea.tfmg.blocks.engines.radial.RadialEngineBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class RadialEngineInputBlockEntity
extends SmartBlockEntity {
    int timer = 10;
    boolean signalChanged;
    public int signal = 0;
    RadialEngineBlockEntity engine;

    public RadialEngineInputBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void setEngine(RadialEngineBlockEntity engine) {
        this.engine = engine;
    }

    public void tick() {
        super.tick();
        if (this.timer > 0) {
            --this.timer;
        }
        if (this.engine != null) {
            if (!(this.f_58857_.m_7702_(this.engine.m_58899_()) instanceof RadialEngineBlockEntity)) {
                this.engine = null;
            }
            if (this.engine != null) {
                this.engine.setInputSingal(this.signal);
            }
        }
        if (this.engine == null && this.timer == 0) {
            this.f_58857_.m_7731_(this.m_58899_(), Blocks.f_50016_.m_49966_(), 3);
        }
        if (this.signalChanged) {
            this.signalChanged = false;
            this.analogSignalChanged(this.f_58857_.m_277086_(this.f_58858_));
        }
    }

    protected void analogSignalChanged(int newSignal) {
        this.signal = newSignal;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (this.engine != null && side == this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_) && cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.engine.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Signal", this.signal);
        if (this.engine != null) {
            compound.m_128405_("X", this.engine.m_58899_().m_123341_());
            compound.m_128405_("Y", this.engine.m_58899_().m_123342_());
            compound.m_128405_("Z", this.engine.m_58899_().m_123343_());
        }
        super.write(compound, clientPacket);
    }

    public void neighbourChanged() {
        if (!this.m_58898_()) {
            return;
        }
        int power = this.f_58857_.m_277086_(this.f_58858_);
        if (power != this.signal) {
            this.signalChanged = true;
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.neighbourChanged();
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        if (this.engine == null) {
            this.engine = (RadialEngineBlockEntity)this.f_58857_.m_7702_(new BlockPos(compound.m_128451_("X"), compound.m_128451_("Y"), compound.m_128451_("Z")));
        }
        this.signal = compound.m_128451_("Signal");
        super.read(compound, clientPacket);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }
}

