/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.ContainerSorter;
import com.tiviacz.travelersbackpack.items.HoseItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncItemStackPacket;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class ServerActions {
    public static void swapTool(Player player, double scrollDelta) {
        if (CapabilityUtils.isWearingBackpack(player)) {
            int i;
            ItemStackHandler inv = CapabilityUtils.getBackpackWrapper(player).getTools();
            if (InventoryHelper.isEmpty(inv)) {
                return;
            }
            int toolSlots = inv.getSlots();
            int lastSlot = toolSlots - 1;
            int j = 0;
            for (int i2 = 0; i2 <= lastSlot; ++i2) {
                if (inv.getStackInSlot(i2).m_41619_()) continue;
                ++j;
            }
            ItemStack[] tools = new ItemStack[j];
            int slot = 0;
            for (i = 0; i <= j - 1; ++i) {
                tools[slot] = inv.getStackInSlot(i).m_41777_();
                ++slot;
            }
            ServerActions.swapTool(scrollDelta, tools, player);
            slot = 0;
            for (i = 0; i <= j - 1; ++i) {
                inv.setStackInSlot(i, tools[slot]);
                ++slot;
            }
            CapabilityUtils.getBackpackWrapper(player).sendDataToClients("ToolsInventory");
        }
    }

    public static void swapTool(double delta, ItemStack[] tools, Player player) {
        int i;
        ItemStack tempStack;
        if (delta > 0.0) {
            tempStack = tools[0];
            for (i = 0; i <= tools.length - 1; ++i) {
                if (i + 1 > tools.length - 1) {
                    tools[tools.length - 1] = player.m_21205_();
                    player.m_21008_(InteractionHand.MAIN_HAND, tempStack);
                    continue;
                }
                tools[i] = tools[i + 1];
            }
        }
        if (delta < 0.0) {
            tempStack = tools[tools.length - 1];
            for (i = tools.length - 1; i >= 0; --i) {
                if (i - 1 < 0) {
                    tools[0] = player.m_21205_();
                    player.m_21008_(InteractionHand.MAIN_HAND, tempStack);
                    continue;
                }
                tools[i] = tools[i - 1];
            }
        }
    }

    public static void equipBackpack(Player player) {
        Level level = player.m_9236_();
        if (!level.f_46443_) {
            if (!CapabilityUtils.isWearingBackpack(player)) {
                if (player.f_36096_ instanceof BackpackItemMenu) {
                    player.m_6915_();
                }
                ItemStack stack = player.m_21205_().m_41777_();
                CapabilityUtils.getCapability(player).ifPresent(attachment -> {
                    attachment.equipBackpack(stack);
                    attachment.synchronise();
                });
                player.m_21205_().m_41774_(1);
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, (1.0f + (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f) * 0.7f);
            } else {
                player.m_6915_();
                player.m_213846_((Component)Component.m_237115_((String)"action.travelersbackpack.equip_otherbackpack"));
            }
        }
    }

    public static void unequipBackpack(Player player) {
        Level level = player.m_9236_();
        if (!level.f_46443_ && CapabilityUtils.isWearingBackpack(player)) {
            if (player.f_36096_ instanceof BackpackItemMenu) {
                player.m_6915_();
            }
            ItemStack backpack = CapabilityUtils.getWearingBackpack(player).m_41777_();
            if (!player.m_150109_().m_36054_(backpack)) {
                player.m_213846_((Component)Component.m_237115_((String)"action.travelersbackpack.unequip_nospace"));
                return;
            }
            CapabilityUtils.getCapability(player).ifPresent(attachment -> {
                attachment.equipBackpack(new ItemStack((ItemLike)Items.f_41852_, 0));
                attachment.synchronise();
            });
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.05f, (1.0f + (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f) * 0.7f);
        }
    }

    public static void switchAbilitySlider(BackpackWrapper wrapper, boolean sliderValue) {
        wrapper.setAbilityEnabled(sliderValue);
        if (wrapper.getBackpackOwner() != null) {
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, wrapper.getBackpackStack()) && !sliderValue) {
                BackpackAbilities.ABILITIES.abilityRemoval(wrapper.getBackpackStack(), wrapper.getBackpackOwner());
            }
            if (wrapper.getBackpackStack().m_41720_() == ModItems.CHICKEN_TRAVELERS_BACKPACK.get() && wrapper.getCooldown() <= 0) {
                BackpackAbilities.ABILITIES.chickenAbilityNew(wrapper.getBackpackStack(), wrapper.getBackpackOwner(), true);
            }
        }
    }

    public static void sortBackpack(Player player, byte screenID, byte button, boolean shiftPressed) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BackpackBaseMenu) {
            BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
            ContainerSorter.selectSort(menu.getWrapper(), player, button, shiftPressed);
        }
    }

    public static void toggleVisibility(Player player) {
        BackpackWrapper wrapper;
        boolean visibility = NbtHelper.getOrDefault((wrapper = CapabilityUtils.getBackpackWrapper(player)).getBackpackStack(), "IsVisible", true);
        wrapper.setVisibility(!visibility);
    }

    public static void toggleSleepingBag(Player player, BlockPos pos) {
        Level level = player.m_9236_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity blockEntity2 = (BackpackBlockEntity)blockEntity;
            if (!blockEntity2.isSleepingBagDeployed()) {
                if (!blockEntity2.deploySleepingBag(level, pos)) {
                    player.m_213846_((Component)Component.m_237115_((String)"action.travelersbackpack.deploy_sleeping_bag"));
                }
            } else {
                blockEntity2.removeSleepingBag(level, blockEntity2.getBlockDirection());
            }
            if (!level.f_46443_) {
                player.m_6915_();
            }
        }
    }

    public static boolean setFluidEffect(Level level, Player player, FluidTank tank) {
        FluidStack fluidStack = tank.getFluid();
        boolean done = false;
        if (EffectFluidRegistry.hasExecutableEffects(fluidStack, level, (Entity)player)) {
            done = EffectFluidRegistry.executeEffects(fluidStack, (Entity)player, level);
        }
        return done;
    }

    public static void switchHoseMode(Player player, double scrollDelta) {
        ItemStack hose = player.m_21205_();
        if (hose.m_41720_() instanceof HoseItem) {
            List<Integer> settings = NbtHelper.getOrDefault(hose, "HoseModes", List.of(Integer.valueOf(1), Integer.valueOf(1)));
            if (scrollDelta > 0.0) {
                int nextMode = settings.get(0) + 1;
                NbtHelper.set(hose, "HoseModes", List.of(Integer.valueOf(nextMode == 4 ? 1 : nextMode), settings.get(1)));
            } else if (scrollDelta < 0.0) {
                int nextMode = settings.get(0) - 1;
                NbtHelper.set(hose, "HoseModes", List.of(Integer.valueOf(nextMode == 0 ? 3 : nextMode), settings.get(1)));
            }
        }
        if (!player.m_9236_().f_46443_) {
            CompoundTag builder = new CompoundTag();
            if (hose.m_41782_() && hose.m_41783_().m_128441_("HoseModes")) {
                builder.m_128365_("HoseModes", (Tag)hose.m_41783_().m_128437_("HoseModes", 3));
            }
            PacketDistributorHelper.sendToPlayer((ServerPlayer)player, new ClientboundSyncItemStackPacket(player.m_19879_(), player.m_150109_().f_35977_, hose, builder));
        }
    }

    public static void toggleHoseTank(Player player) {
        ItemStack hose = player.m_21205_();
        if (hose.m_41720_() instanceof HoseItem) {
            List<Integer> settings = NbtHelper.getOrDefault(hose, "HoseModes", List.of(Integer.valueOf(1), Integer.valueOf(1)));
            if (settings.get(1) == 1) {
                NbtHelper.set(hose, "HoseModes", List.of(settings.get(0), Integer.valueOf(2)));
            } else {
                NbtHelper.set(hose, "HoseModes", List.of(settings.get(0), Integer.valueOf(1)));
            }
        }
        if (!player.m_9236_().f_46443_) {
            CompoundTag builder = new CompoundTag();
            if (hose.m_41782_() && hose.m_41783_().m_128441_("HoseModes")) {
                builder.m_128365_("HoseModes", (Tag)hose.m_41783_().m_128437_("HoseModes", 3));
            }
            PacketDistributorHelper.sendToPlayer((ServerPlayer)player, new ClientboundSyncItemStackPacket(player.m_19879_(), player.m_150109_().f_35977_, hose, builder));
        }
    }
}

