/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.jukebox.JukeboxUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;

public class UpgradeManager {
    public BackpackWrapper wrapper;
    public ItemStackHandler upgradesHandler;
    public Map<Integer, Optional<? extends IUpgrade>> mappedUpgrades;
    public Map<Optional<? extends IUpgrade>, Integer> slotMappedUpgrades;
    public Optional<TanksUpgrade> tanksUpgrade = Optional.empty();
    public Optional<CraftingUpgrade> craftingUpgrade = Optional.empty();
    public Optional<AutoPickupUpgrade> pickupUpgrade = Optional.empty();
    public Optional<JukeboxUpgrade> jukeboxUpgrade = Optional.empty();
    public Optional<FeedingUpgrade> feedingUpgrade = Optional.empty();
    public Optional<MagnetUpgrade> magnetUpgrade = Optional.empty();
    public Optional<VoidUpgrade> voidUpgrade = Optional.empty();
    public static final byte LOAD_TANKS = 0;
    public static final byte LOAD_CRAFTING = 1;
    public static final byte LOAD_PICKUP = 2;
    public static final byte LOAD_JUKEBOX = 3;
    public static final byte LOAD_FEEDING = 4;
    public static final byte LOAD_MAGNET = 5;
    public static final byte LOAD_VOID = 6;

    public UpgradeManager(BackpackWrapper wrapper) {
        this(wrapper, List.of(Byte.valueOf((byte)0), Byte.valueOf((byte)1), Byte.valueOf((byte)2), Byte.valueOf((byte)3), Byte.valueOf((byte)4), Byte.valueOf((byte)5), Byte.valueOf((byte)6)));
    }

    public UpgradeManager(BackpackWrapper wrapper, List<Byte> dataLoad) {
        this.wrapper = wrapper;
        this.upgradesHandler = wrapper.getUpgrades();
        this.mappedUpgrades = new HashMap<Integer, Optional<? extends IUpgrade>>();
        this.slotMappedUpgrades = new HashMap<Optional<? extends IUpgrade>, Integer>();
        this.initializeUpgrades(dataLoad);
    }

    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    public ItemStackHandler getUpgradesHandler() {
        return this.upgradesHandler;
    }

    public void initializeUpgrades(List<Byte> dataLoad) {
        for (int i = 0; i < this.getUpgradesHandler().getSlots(); ++i) {
            if (dataLoad.contains((byte)0) && this.getUpgradesHandler().getStackInSlot(i).m_41720_() == ModItems.TANKS_UPGRADE.get() && this.tanksUpgrade.isEmpty()) {
                this.createTanksUpgrade(i);
            }
            if (dataLoad.contains((byte)1) && this.getUpgradesHandler().getStackInSlot(i).m_41720_() == ModItems.CRAFTING_UPGRADE.get() && this.craftingUpgrade.isEmpty()) {
                this.createCraftingUpgrade(i);
            }
            if (dataLoad.contains((byte)2) && this.getUpgradesHandler().getStackInSlot(i).m_41720_() == ModItems.PICKUP_UPGRADE.get() && this.pickupUpgrade.isEmpty()) {
                this.createAutoPickupUpgrade(i);
            }
            if (dataLoad.contains((byte)3) && this.getUpgradesHandler().getStackInSlot(i).m_41720_() == ModItems.JUKEBOX_UPGRADE.get() && this.jukeboxUpgrade.isEmpty()) {
                this.createJukeboxUpgrade(i);
            }
            if (dataLoad.contains((byte)4) && this.getUpgradesHandler().getStackInSlot(i).m_41720_() == ModItems.FEEDING_UPGRADE.get() && this.feedingUpgrade.isEmpty()) {
                this.createFeedingUpgrade(i);
            }
            if (dataLoad.contains((byte)6) && this.getUpgradesHandler().getStackInSlot(i).m_41720_() == ModItems.VOID_UPGRADE.get() && this.voidUpgrade.isEmpty()) {
                this.createVoidUpgrade(i);
            }
            if (!dataLoad.contains((byte)5) || this.getUpgradesHandler().getStackInSlot(i).m_41720_() != ModItems.MAGNET_UPGRADE.get() || !this.magnetUpgrade.isEmpty()) continue;
            this.createMagnetUpgrade(i);
        }
    }

    public void detectedChange(ItemStackHandler tracker, int slot) {
        boolean needsUpdate = false;
        boolean updateTabsOnly = true;
        if (this.getUpgradesHandler().getStackInSlot(slot).m_41720_() == ModItems.TANKS_UPGRADE.get()) {
            if (this.tanksUpgrade.isEmpty()) {
                this.createTanksUpgrade(slot);
                updateTabsOnly = false;
                needsUpdate = true;
            }
            if (needsUpdate) {
                this.getWrapper().requestMenuAndScreenUpdate(updateTabsOnly);
            }
        }
        if (this.getUpgradesHandler().getStackInSlot(slot).m_41720_() == ModItems.CRAFTING_UPGRADE.get()) {
            if (this.craftingUpgrade.isEmpty()) {
                this.createCraftingUpgrade(slot);
                needsUpdate = true;
            }
            if (needsUpdate) {
                this.getWrapper().requestMenuAndScreenUpdate(updateTabsOnly);
            }
        }
        if (this.getUpgradesHandler().getStackInSlot(slot).m_41720_() == ModItems.PICKUP_UPGRADE.get()) {
            if (this.pickupUpgrade.isEmpty()) {
                this.createAutoPickupUpgrade(slot);
                needsUpdate = true;
            }
            if (needsUpdate) {
                this.getWrapper().requestMenuAndScreenUpdate(updateTabsOnly);
            }
        }
        if (this.getUpgradesHandler().getStackInSlot(slot).m_41720_() == ModItems.JUKEBOX_UPGRADE.get()) {
            if (this.jukeboxUpgrade.isEmpty()) {
                this.createJukeboxUpgrade(slot);
                needsUpdate = true;
            }
            if (needsUpdate) {
                this.getWrapper().requestMenuAndScreenUpdate(updateTabsOnly);
            }
        }
        if (this.getUpgradesHandler().getStackInSlot(slot).m_41720_() == ModItems.FEEDING_UPGRADE.get()) {
            if (this.feedingUpgrade.isEmpty()) {
                this.createFeedingUpgrade(slot);
                needsUpdate = true;
            }
            if (needsUpdate) {
                this.getWrapper().requestMenuAndScreenUpdate(updateTabsOnly);
            }
        }
        if (this.getUpgradesHandler().getStackInSlot(slot).m_41720_() == ModItems.VOID_UPGRADE.get()) {
            if (this.voidUpgrade.isEmpty()) {
                this.createVoidUpgrade(slot);
                needsUpdate = true;
            }
            if (needsUpdate) {
                this.getWrapper().requestMenuAndScreenUpdate(updateTabsOnly);
            }
        }
        if (this.getUpgradesHandler().getStackInSlot(slot).m_41720_() == ModItems.MAGNET_UPGRADE.get()) {
            if (this.magnetUpgrade.isEmpty()) {
                this.createMagnetUpgrade(slot);
                needsUpdate = true;
            }
            if (needsUpdate) {
                this.getWrapper().requestMenuAndScreenUpdate(updateTabsOnly);
            }
        }
        if (this.getTabStatus(tracker.getStackInSlot(slot)) != this.getTabStatus(this.getUpgradesHandler().getStackInSlot(slot))) {
            needsUpdate = true;
            ItemStack stackToSet = this.getUpgradesHandler().getStackInSlot(slot).m_41777_();
            tracker.setStackInSlot(slot, stackToSet);
            if (needsUpdate) {
                this.getWrapper().requestMenuAndScreenUpdate(updateTabsOnly);
            }
        }
        if (this.getUpgradeCount() != this.mappedUpgrades.values().size()) {
            this.invalidateUpgrade(slot);
            updateTabsOnly = false;
            if (needsUpdate) {
                this.getWrapper().requestMenuAndScreenUpdate(updateTabsOnly);
            }
        }
    }

    public void createCraftingUpgrade(int i) {
        NonNullList contents = NbtHelper.getOrDefault(this.getUpgradesHandler().getStackInSlot(i), "Inventory", NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_));
        this.craftingUpgrade = Optional.of(new CraftingUpgrade(this, i, (NonNullList<ItemStack>)contents));
        this.mappedUpgrades.put(i, this.craftingUpgrade);
        this.slotMappedUpgrades.put(this.craftingUpgrade, i);
    }

    public void createTanksUpgrade(int slot) {
        Fluids fluids = NbtHelper.getOrDefault(this.getUpgradesHandler().getStackInSlot(slot), "Fluids", new Fluids(FluidStack.EMPTY, FluidStack.EMPTY));
        this.tanksUpgrade = Optional.of(new TanksUpgrade(this, slot, fluids));
        this.mappedUpgrades.put(slot, this.tanksUpgrade);
        this.slotMappedUpgrades.put(this.tanksUpgrade, slot);
    }

    public void createAutoPickupUpgrade(int slot) {
        NonNullList filter = NbtHelper.getOrDefault(this.getUpgradesHandler().getStackInSlot(slot), "Inventory", NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_));
        this.pickupUpgrade = Optional.of(new AutoPickupUpgrade(this, slot, (NonNullList<ItemStack>)filter));
        this.mappedUpgrades.put(slot, this.pickupUpgrade);
        this.slotMappedUpgrades.put(this.pickupUpgrade, slot);
    }

    public void createJukeboxUpgrade(int slot) {
        NonNullList musicDisk = NbtHelper.getOrDefault(this.getUpgradesHandler().getStackInSlot(slot), "Inventory", NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_));
        this.jukeboxUpgrade = Optional.of(new JukeboxUpgrade(this, slot, (NonNullList<ItemStack>)musicDisk));
        this.mappedUpgrades.put(slot, this.jukeboxUpgrade);
        this.slotMappedUpgrades.put(this.jukeboxUpgrade, slot);
    }

    public void createFeedingUpgrade(int slot) {
        NonNullList filter = NbtHelper.getOrDefault(this.getUpgradesHandler().getStackInSlot(slot), "Inventory", NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_));
        this.feedingUpgrade = Optional.of(new FeedingUpgrade(this, slot, (NonNullList<ItemStack>)filter));
        this.mappedUpgrades.put(slot, this.feedingUpgrade);
        this.slotMappedUpgrades.put(this.feedingUpgrade, slot);
    }

    public void createMagnetUpgrade(int slot) {
        NonNullList filter = NbtHelper.getOrDefault(this.getUpgradesHandler().getStackInSlot(slot), "Inventory", NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_));
        this.magnetUpgrade = Optional.of(new MagnetUpgrade(this, slot, (NonNullList<ItemStack>)filter));
        this.mappedUpgrades.put(slot, this.magnetUpgrade);
        this.slotMappedUpgrades.put(this.magnetUpgrade, slot);
    }

    public void createVoidUpgrade(int slot) {
        NonNullList filter = NbtHelper.getOrDefault(this.getUpgradesHandler().getStackInSlot(slot), "Inventory", NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_));
        this.voidUpgrade = Optional.of(new VoidUpgrade(this, slot, (NonNullList<ItemStack>)filter));
        this.mappedUpgrades.put(slot, this.voidUpgrade);
        this.slotMappedUpgrades.put(this.voidUpgrade, slot);
    }

    public void invalidateUpgrade(int slot) {
        Optional<? extends IUpgrade> upgrade = this.mappedUpgrades.get(slot);
        this.getWrapper().upgradesTracker.setStackInSlot(slot, ItemStack.f_41583_);
        if (upgrade.isPresent()) {
            this.mappedUpgrades.remove(slot);
            this.slotMappedUpgrades.remove(upgrade);
            upgrade.get().remove();
        }
    }

    public int getUpgradeCount() {
        int u = 0;
        for (int i = 0; i < this.getUpgradesHandler().getSlots(); ++i) {
            if (this.getUpgradesHandler().getStackInSlot(i).m_41619_()) continue;
            ++u;
        }
        return u;
    }

    public boolean getTabStatus(ItemStack stack) {
        return NbtHelper.getOrDefault(stack, "TabOpen", false);
    }

    public boolean hasTickingUpgrade() {
        boolean hasTickingUpgrade = false;
        if (this.magnetUpgrade.isPresent() && this.magnetUpgrade.get().isEnabled()) {
            hasTickingUpgrade = true;
        }
        if (this.feedingUpgrade.isPresent() && this.feedingUpgrade.get().isEnabled()) {
            hasTickingUpgrade = true;
        }
        return hasTickingUpgrade;
    }
}

