/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.util.FluidStackHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundFillTankPacket {
    private final boolean leftTank;

    public ServerboundFillTankPacket(boolean leftTank) {
        this.leftTank = leftTank;
    }

    public static ServerboundFillTankPacket decode(FriendlyByteBuf buffer) {
        boolean leftTank = buffer.readBoolean();
        return new ServerboundFillTankPacket(leftTank);
    }

    public static void encode(ServerboundFillTankPacket message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.leftTank);
    }

    public static void handle(ServerboundFillTankPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player;
                AbstractContainerMenu patt2035$temp = serverPlayer.f_36096_;
                if (patt2035$temp instanceof BackpackBaseMenu) {
                    ItemStack newCarried;
                    BackpackBaseMenu menu = (BackpackBaseMenu)patt2035$temp;
                    BackpackWrapper wrapper = menu.getWrapper();
                    FluidTank tank = message.leftTank ? wrapper.getUpgradeManager().tanksUpgrade.get().getLeftTank() : wrapper.getUpgradeManager().tanksUpgrade.get().getRightTank();
                    ItemStack carried = menu.m_142621_();
                    if (FluidUtil.getFluidContained((ItemStack)carried).isPresent() && carried.m_41613_() == 1) {
                        SoundEvent fluidSound = tank.isEmpty() ? SoundEvents.f_11778_ : tank.getFluid().getFluid().getFluidType().getSound(tank.getFluid(), SoundActions.BUCKET_EMPTY);
                        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)carried, (IFluidHandler)tank, (int)wrapper.getBackpackTankCapacity(), (Player)(wrapper.getScreenID() == 1 ? null : serverPlayer), (boolean)true);
                        if (result.isSuccess()) {
                            if (wrapper.getScreenID() == 1) {
                                InventoryActions.playFluidSound(wrapper.getBackpackOwner(), wrapper.getPlayersUsing(), fluidSound, false);
                            }
                            menu.m_142503_(result.getResult());
                        }
                    } else if (FluidUtil.getFluidHandler((ItemStack)carried).isPresent() && FluidUtil.getFluidContained((ItemStack)carried).isEmpty()) {
                        ItemStack carriedCopy = carried.m_41777_();
                        int count = carriedCopy.m_41613_();
                        carriedCopy.m_41764_(count - 1);
                        SoundEvent fluidSound = tank.isEmpty() ? SoundEvents.f_11781_ : tank.getFluid().getFluid().getFluidType().getSound(tank.getFluid(), SoundActions.BUCKET_FILL);
                        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)carried, (IFluidHandler)tank, (int)wrapper.getBackpackTankCapacity(), (Player)(wrapper.getScreenID() == 1 ? null : serverPlayer), (boolean)true);
                        if (result.isSuccess()) {
                            if (carriedCopy.m_41613_() > 0) {
                                serverPlayer.m_150109_().m_150079_(result.getResult());
                                menu.m_142503_(carriedCopy);
                            } else {
                                menu.m_142503_(result.getResult());
                            }
                            if (wrapper.getScreenID() == 1) {
                                InventoryActions.playFluidSound(wrapper.getBackpackOwner(), wrapper.getPlayersUsing(), fluidSound, true);
                            }
                        }
                    } else if (carried.m_41720_() instanceof PotionItem && carried.m_41720_() != Items.f_42590_) {
                        if (carried.m_41613_() == 1 && ServerboundFillTankPacket.tryEmptyPotion(carried, tank)) {
                            InventoryActions.playFluidSound(wrapper.getBackpackOwner(), wrapper.getPlayersUsing(), SoundEvents.f_11772_, true);
                            menu.m_142503_(new ItemStack((ItemLike)Items.f_42590_));
                        }
                    } else if (carried.m_41720_() == Items.f_42590_ && !(newCarried = ServerboundFillTankPacket.tryFillPotion(carried, tank, serverPlayer, true)).m_41619_()) {
                        ItemStack result = ServerboundFillTankPacket.tryFillPotion(carried, tank, serverPlayer, false);
                        InventoryActions.playFluidSound(wrapper.getBackpackOwner(), wrapper.getPlayersUsing(), SoundEvents.f_11772_, false);
                        menu.m_142503_(result);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static boolean tryEmptyPotion(ItemStack carried, FluidTank tank) {
        int amount = 250;
        FluidStack fluidStack = new FluidStack((Fluid)ModFluids.POTION_FLUID.get(), amount);
        FluidStackHelper.setFluidStackNBT(carried, fluidStack);
        if ((tank.isEmpty() || tank.getFluid().isFluidEqual(fluidStack)) && tank.getFluidAmount() + amount <= tank.getCapacity()) {
            tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static ItemStack tryFillPotion(ItemStack carried, FluidTank tank, ServerPlayer player, boolean simulate) {
        if (tank.getFluid().getFluid() == ModFluids.POTION_FLUID.get() && tank.getFluidAmount() >= 250) {
            ItemStack filledPotion = FluidStackHelper.getItemStackFromFluidStack(tank.getFluid());
            if (simulate) {
                return filledPotion;
            }
            ItemStack carriedCopy = carried.m_41777_();
            int count = carriedCopy.m_41613_();
            carriedCopy.m_41764_(count - 1);
            tank.drain(250, IFluidHandler.FluidAction.EXECUTE);
            if (carriedCopy.m_41613_() > 0) {
                player.m_150109_().m_150079_(filledPotion);
                return carriedCopy;
            }
            return filledPotion;
        }
        return ItemStack.f_41583_;
    }
}

