/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import com.tiviacz.travelersbackpack.inventory.BackpackSettingsContainer;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundOpenSettingsPacket {
    private final int entityId;
    private final boolean open;

    public ServerboundOpenSettingsPacket(int entityId, boolean open) {
        this.entityId = entityId;
        this.open = open;
    }

    public static ServerboundOpenSettingsPacket decode(FriendlyByteBuf buffer) {
        int entityId = buffer.readInt();
        boolean open = buffer.readBoolean();
        return new ServerboundOpenSettingsPacket(entityId, open);
    }

    public static void encode(ServerboundOpenSettingsPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityId);
        buffer.writeBoolean(message.open);
    }

    public static void handle(ServerboundOpenSettingsPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player.m_19879_() == message.entityId) {
                AbstractContainerMenu patt1732$temp = player.f_36096_;
                if (patt1732$temp instanceof BackpackBaseMenu) {
                    BackpackBaseMenu menu = (BackpackBaseMenu)patt1732$temp;
                    if (message.open) {
                        if (menu.getWrapper().getScreenID() == 3) {
                            BlockEntity patt2005$temp = player.m_9236_().m_7702_(menu.getWrapper().getBackpackPos());
                            if (patt2005$temp instanceof BackpackBlockEntity) {
                                backpackBlockEntity = (BackpackBlockEntity)patt2005$temp;
                                backpackBlockEntity.openSettings((Player)player, backpackBlockEntity, menu.getWrapper().getBackpackPos());
                            }
                        } else {
                            BackpackSettingsContainer.openSettings(player, menu.getWrapper().getBackpackStack(), menu.getWrapper().getScreenID());
                        }
                    }
                } else {
                    AbstractContainerMenu patt2516$temp = player.f_36096_;
                    if (patt2516$temp instanceof BackpackSettingsMenu) {
                        BackpackSettingsMenu menu = (BackpackSettingsMenu)patt2516$temp;
                        if (!message.open) {
                            if (menu.getWrapper().getScreenID() == 3) {
                                BlockEntity patt2794$temp = player.m_9236_().m_7702_(menu.getWrapper().getBackpackPos());
                                if (patt2794$temp instanceof BackpackBlockEntity) {
                                    backpackBlockEntity = (BackpackBlockEntity)patt2794$temp;
                                    backpackBlockEntity.openBackpack((Player)player, backpackBlockEntity, menu.getWrapper().getBackpackPos());
                                }
                            } else {
                                BackpackContainer.openBackpack(player, menu.getWrapper().getBackpackStack(), menu.getWrapper().getScreenID());
                            }
                        }
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

