/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundTabPacket {
    private final int slot;
    private final boolean open;
    private final int packetType;
    public static final int TAB_OPEN = 0;
    public static final int UPGRADE_ENABLED = 1;
    public static final int SHIFT_CLICK_TO_BACKPACK = 2;
    public static final int PLAY_RECORD = 3;

    public ServerboundTabPacket(int slot, boolean open, int packetType) {
        this.slot = slot;
        this.open = open;
        this.packetType = packetType;
    }

    public static ServerboundTabPacket decode(FriendlyByteBuf buffer) {
        int slot = buffer.readInt();
        boolean open = buffer.readBoolean();
        int packetType = buffer.readInt();
        return new ServerboundTabPacket(slot, open, packetType);
    }

    public static void encode(ServerboundTabPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slot);
        buffer.writeBoolean(message.open);
        buffer.writeInt(message.packetType);
    }

    public static void handle(ServerboundTabPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player instanceof ServerPlayer) {
                BackpackBaseMenu menu;
                ItemStack upgradeStack;
                ServerPlayer serverPlayer = player;
                AbstractContainerMenu patt1856$temp = serverPlayer.f_36096_;
                if (patt1856$temp instanceof BackpackBaseMenu && !(upgradeStack = (menu = (BackpackBaseMenu)patt1856$temp).getWrapper().getUpgrades().getStackInSlot(message.slot)).m_41619_()) {
                    ItemStack updateStack = upgradeStack.m_41777_();
                    NbtHelper.set(updateStack, ServerboundTabPacket.getPacketType(message.packetType), message.open);
                    menu.getWrapper().getUpgrades().setStackInSlot(message.slot, updateStack);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static String getPacketType(int type) {
        return switch (type) {
            case 0 -> "TabOpen";
            case 1 -> "UpgradeEnabled";
            case 2 -> "ShiftClickToBackpack";
            case 3 -> "IsPlaying";
            default -> "TabOpen";
        };
    }
}

