/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.grid.vampiresdelight.common.block.ConsumableCakeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ConsumableCandleCakeBlock
extends AbstractCandleBlock {
    public static final BooleanProperty LIT = AbstractCandleBlock.f_151895_;
    protected static final VoxelShape CAKE_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    protected static final VoxelShape CANDLE_SHAPE = Block.m_49796_((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)CAKE_SHAPE, (VoxelShape)CANDLE_SHAPE);
    private static final Map<Pair<Block, ConsumableCakeBlock>, ConsumableCandleCakeBlock> BY_CANDLE_AND_CAKE = Maps.newHashMap();
    private static final Iterable<Vec3> PARTICLE_OFFSETS = ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5));
    private final ConsumableCakeBlock cakeBlock;
    private final Block candleBlock;

    public ConsumableCandleCakeBlock(BlockBehaviour.Properties properties, ConsumableCakeBlock cakeBlock, Block candleBlock) {
        super(properties);
        this.cakeBlock = cakeBlock;
        this.candleBlock = candleBlock;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
        BY_CANDLE_AND_CAKE.put((Pair<Block, ConsumableCakeBlock>)Pair.of((Object)candleBlock, (Object)((Object)cakeBlock)), this);
    }

    protected Iterable<Vec3> m_142199_(BlockState pState) {
        return PARTICLE_OFFSETS;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_150930_(Items.f_42409_) || itemstack.m_150930_(Items.f_42613_)) {
            return InteractionResult.PASS;
        }
        if (ConsumableCandleCakeBlock.candleHit(pHit) && pPlayer.m_21120_(pHand).m_41619_() && ((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            ConsumableCandleCakeBlock.m_151899_((Player)pPlayer, (BlockState)pState, (LevelAccessor)pLevel, (BlockPos)pPos);
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        InteractionResult interactionresult = this.cakeBlock.consumeBite(pLevel, pPos, this.cakeBlock.m_49966_(), pPlayer);
        if (interactionresult.m_19077_()) {
            ConsumableCandleCakeBlock.m_49950_((BlockState)pState, (Level)pLevel, (BlockPos)pPos);
        }
        return interactionresult;
    }

    private static boolean candleHit(BlockHitResult pHit) {
        return pHit.m_82450_().f_82480_ - (double)pHit.m_82425_().m_123342_() > 0.5;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LIT});
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)this.cakeBlock);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        return pDirection == Direction.DOWN && !pState.m_60710_((LevelReader)pLevel, pPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos.m_7495_()).m_280296_();
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        return ConsumableCakeBlock.f_152743_;
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public static BlockState byCandle(Block candleBlock, ConsumableCakeBlock cakeBlock) {
        return BY_CANDLE_AND_CAKE.get(Pair.of((Object)candleBlock, (Object)((Object)cakeBlock))).m_49966_();
    }

    public static boolean hasCandle(Block candleBlock, ConsumableCakeBlock cakeBlock) {
        return BY_CANDLE_AND_CAKE.get(Pair.of((Object)candleBlock, (Object)((Object)cakeBlock))) != null;
    }

    public Block getCandleBlock() {
        return this.candleBlock;
    }

    public ConsumableCakeBlock getCakeBlock() {
        return this.cakeBlock;
    }

    public static Iterable<Block> getAllCandleCakes() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block) != null && "vampiresdelight".equals(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey(block)).m_135827_()) && block instanceof ConsumableCandleCakeBlock).collect(Collectors.toList());
    }
}

