/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vectorwing.farmersdelight.common.block.FeastBlock;

public class WeirdJellyBlock
extends FeastBlock {
    protected static final VoxelShape PLATE_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    protected static final VoxelShape JELLY_SHAPE = Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_);

    public WeirdJellyBlock(BlockBehaviour.Properties properties, Supplier<Item> servingItem, boolean hasLeftovers) {
        super(properties, servingItem, hasLeftovers);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)SERVINGS) == 0 ? PLATE_SHAPE : JELLY_SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.m_60713_((Block)this) || super.m_6104_(state, adjacentBlockState, side);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fl) {
        if (entity.m_20162_()) {
            super.m_142072_(level, state, pos, entity, fl);
        } else {
            entity.m_142535_(fl, 0.0f, entity.m_269291_().m_268989_());
        }
    }

    public void m_5548_(BlockGetter blockGetter, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(blockGetter, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        if (vec3.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vec3.f_82479_, -vec3.f_82480_ * d0, vec3.f_82481_);
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        double d0 = Math.abs(entity.m_20184_().f_82480_);
        if (d0 < 0.1 && !entity.m_20161_()) {
            double d1 = 0.4 + d0 * 0.2;
            entity.m_20256_(entity.m_20184_().m_82542_(d1, 1.0, d1));
        }
        super.m_141947_(level, pos, state, entity);
    }
}

